import java.awt.AWTEventMulticaster;
import java.util.EventListener;

public class PanelEventMulticaster extends AWTEventMulticaster implements IPanelListener {

   protected PanelEventMulticaster(EventListener a, EventListener b) {
       super(a, b);
   }

   public static IPanelListener add(IPanelListener a, IPanelListener b) {
       return (IPanelListener)addInternal(a, b);
   }

   public static IPanelListener remove(IPanelListener l, IPanelListener oldl) {
       return (IPanelListener) removeInternal(l, oldl);
   }

   public static IPanelListener addInternal(IPanelListener a, IPanelListener b) {
       if(a == null) return b;
       if(b == null) return a;
       return new PanelEventMulticaster(a, b);
   }

   protected IPanelListener remove(IPanelListener old) {
       if(old == a) return (IPanelListener)b;
       if(old == b) return (IPanelListener)a;
       IPanelListener a2 = (IPanelListener)removeInternal(a, old);
       IPanelListener b2 = (IPanelListener)removeInternal(b, old);
       if(a2 == a && b2 == b) return this;
       return addInternal(a2, b2);
   }

   public void onDeactivate(PanelEvent pe) {
       if(a != null) ((IPanelListener)a).onDeactivate(pe);
       if(b != null) ((IPanelListener)b).onDeactivate(pe);
   }

   public void onActivate(PanelEvent pe) {
       if(a != null) ((IPanelListener)a).onActivate(pe);
       if(b != null) ((IPanelListener)b).onActivate(pe);
   }

   public void setAtom(PanelEvent pe) {
       if(a != null) ((IPanelListener)a).setAtom(pe);
       if(b != null) ((IPanelListener)b).setAtom(pe);
   }

   public void setStyle(PanelEvent pe) {
       if(a != null) ((IPanelListener)a).setStyle(pe);
       if(b != null) ((IPanelListener)b).setStyle(pe);
   }
}
