import java.awt.Color;
import java.util.*;

public class TState {
   int number;
   String Name;
   Color clr;

   public static TState decode(String input) throws Exception {
       StringTokenizer z = new StringTokenizer(input, "\t", false);
       TState result = new TState();

       while(z.hasMoreTokens()) {
           result.number = Integer.valueOf(z.nextToken()).intValue();
           result.Name = z.nextToken();

           result.clr = Color.decode(z.nextToken());
       }
       return result;
   }

   public static Color getStateColor(int number, Map states){
       TState s = (TState) states.get(new Integer(number));
       if(s == null) return new Color(204,204,204);
       return s.clr;
   }

   public static String getStateName(int number, Map states) {
       TState t = (TState) states.get(new Integer(number));
       if(t == null) return "Unknown";
       else return t.Name;
   }
}
