import java.awt.*;
import java.awt.image.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;

import javax.media.j3d.*;
import com.sun.j3d.utils.geometry.*;
import com.sun.j3d.loaders.objectfile.*;
import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.universe.*;
import javax.vecmath.*;
import com.sun.j3d.utils.behaviors.mouse.*;

class IceCreamCone extends Group {
   private Cone c;
   private Sphere s;

   public IceCreamCone(
   	float radius,
       float offset,
       Color3f ambient,
       Color3f emissive,
       Color3f diffuse,
       Color3f specular,
       float shininess
   ) {
   	Appearance app;
       TransformGroup objTranz;
       Transform3D t;

   	s = new Sphere(radius);
       app = s.getAppearance();
       app.setMaterial(new Material(ambient, emissive, diffuse, specular, shininess));
       t = new Transform3D();
       t.set(new Vector3d(0, offset, 0));
       objTranz = new TransformGroup(t);
       objTranz.addChild(s);
       addChild(objTranz);

       float hcone = (float)Math.sqrt((offset*offset) - (radius*radius));
       float alpha = (float)Math.atan(radius/hcone);
       float rcone = hcone * (float)Math.sin(alpha);
       float lcone = hcone * (float)Math.cos(alpha);

       c = new Cone(rcone, lcone);
       app = c.getAppearance();
       app.setMaterial(new Material(ambient, emissive, diffuse, specular, shininess));

       t = new Transform3D();
       t.rotX(Math.PI);
       TransformGroup rotation = new TransformGroup(t);
       rotation.addChild(c);

       t = new Transform3D();
       t.set(new Vector3d(0, lcone/2, 0));
       objTranz = new TransformGroup(t);
       objTranz.addChild(rotation);
       addChild(objTranz);
   }
}

class BiCone extends Group {
   private IceCreamCone c1, c2;

	public BiCone(
   	float radius,
       float offset,
       Color3f ambient,
       Color3f emissive,
       Color3f diffuse,
       Color3f specular,
       float shininess
   ) {
   	c1 = new IceCreamCone(radius, offset, ambient, emissive, diffuse, specular, shininess);
       addChild(c1);

   	c2 = new IceCreamCone(radius, offset, ambient, emissive, diffuse, specular, shininess);
       Transform3D t = new Transform3D();
       t.rotX(Math.PI);
       TransformGroup tg = new TransformGroup(t);
       tg.addChild(c2);
       addChild(tg);
    }
}

class QuadCone extends Group {
   private IceCreamCone c1, c2, c3, c4;

	public QuadCone(
   	float radius,
       float offset,
       Color3f ambient,
       Color3f emissive,
       Color3f diffuse,
       Color3f specular,
       float shininess
   ) {
   	c1 = new IceCreamCone(radius, offset, ambient, emissive, diffuse, specular, shininess);
       addChild(c1);

   	c2 = new IceCreamCone(radius, offset, ambient, emissive, diffuse, specular, shininess);
       Transform3D t = new Transform3D();
       t.rotX(Math.PI);
       TransformGroup tg = new TransformGroup(t);
       tg.addChild(c2);
       addChild(tg);

   	c3 = new IceCreamCone(radius, offset, ambient, emissive, diffuse, specular, shininess);
       t = new Transform3D();
       t.rotZ(Math.PI/2);
       tg = new TransformGroup(t);
       tg.addChild(c3);
       addChild(tg);

   	c4 = new IceCreamCone(radius, offset, ambient, emissive, diffuse, specular, shininess);
       t = new Transform3D();
       t.rotZ(-Math.PI/2);
       tg = new TransformGroup(t);
       tg.addChild(c4);
       addChild(tg);
    }
}

class OctaCone extends Group {
   private QuadCone q1, q2;

   public OctaCone(
   	float radius,
       float offset,
       Color3f ambient,
       Color3f emissive,
       Color3f diffuse,
       Color3f specular,
       float shininess
   ) {
       q1 = new QuadCone(radius, offset, ambient, emissive, diffuse, specular, shininess);
       Transform3D t = new Transform3D();
       t.rotZ(Math.PI/4);
       TransformGroup tg = new TransformGroup(t);
       tg.addChild(q1);
       addChild(tg);

       q2 = new QuadCone(radius, offset, ambient, emissive, diffuse, specular, shininess);
       t = new Transform3D();
       t.rotZ(Math.PI/4);
       tg = new TransformGroup(t);
       t = new Transform3D();
       t.rotY(Math.PI/2);
       TransformGroup tgg = new TransformGroup(t);
       tg.addChild(q2);
       tgg.addChild(tg);
       addChild(tgg);
   }
}

public class AtomAni extends JPanel implements IPanelListener, ActionListener, ItemListener {
	private static final String[] orbitals = {"1s", "2s", "2p", "3s", "3p", "4s", "3d", "4p", "5s", "4d", "5p", "6s", "4f", "5d", "6p", "7s", "5f", "6d", "7p"};
	private static final int[] iOrbitals =   {2, 2, 6, 2, 6, 2, 10, 6, 2, 10, 6, 2, 14, 10, 6, 2, 14, 10, 2};
	private static final int[] nOrbitals =   {0, 2, 8, 10, 16, 18, 28, 34, 36, 46, 52, 54, 68, 78, 84, 86, 100, 110, 112};

   private static final Color[] cLabels = {new Color(255,255,255), new Color(255, 128, 0), new Color(0, 0, 128), new Color(0, 255, 0), new Color(128,0,128)};
   private static final String[] sLabels = {"Nucleus", "s orbital", "p orbital", "d orbital", "f orbital"};

   private JCheckBox[] cbOrbitals = new JCheckBox[orbitals.length];
   private Group[] grpOrbitals = new Group[orbitals.length];
   private int iAtomicNumber = 0;

   private static final BoundingSphere bounds = new BoundingSphere(new Point3d(0.0,0.0,0.0), 100.0);
   public static final Color3f white = new Color3f(1.0f, 1.0f, 1.0f);
   public static final Color3f black = new Color3f(0.0f, 0.0f, 0.0f);
   public static final Color3f ltGreen = new Color3f(0.0f, 1.0f, 0.0f);
   public static final Color3f ltRed = new Color3f(1.0f, 0.0f, 0.0f);
   public static final Color3f red = new Color3f(0.5f, 0.0f, 0.0f);
   public static final Color3f purple = new Color3f(0.5f, 0.0f, 0.5f);

   private Canvas3D c;
   private Primitive shape;
   private Transform3D t;
   private TransformGroup objTranz;
   private Appearance app;

//   private JMenuItem miSaveGraphToFile = new JMenuItem("Save Model...", 'S');
//   private JMenu pmContext = new JCoolMenu("Panel");

   private JCheckBox cbRealtime = new JCheckBox("Realtime Update", true);

	public AtomAni() {
   	setBackground(new Color(0, 0, 0));

   	setLayout(new BorderLayout());
       JPanel pToolbar = new JPanel();
       pToolbar.setBorder(new EtchedBorder());
       pToolbar.setLayout(new FlowLayout(FlowLayout.LEFT));

       Dimension d = new Dimension(40,40);
       for(int i=0;i<cLabels.length;i++) {
       	JPanel p = new JPanel();
           p.setMaximumSize(d);
           p.setBackground(cLabels[i]);
           pToolbar.add(p);
           JLabel l = new JLabel(sLabels[i]);
           pToolbar.add(l);
           pToolbar.add(new JSeparator(SwingConstants.VERTICAL));
       }
       cbRealtime.setActionCommand("Realtime");
       cbRealtime.addActionListener(this);
       pToolbar.add(cbRealtime);

       JButton b = new JButton("Update");
       b.setActionCommand("Update");
       b.addActionListener(this);
       pToolbar.add(b);

/*       b = new JButton("Save");
       b.setActionCommand("FileSaveModel");
       b.addActionListener(this);
       pToolbar.add(b);*/

       add("North", pToolbar);

       JPanel pSelector = new JPanel();
       pSelector.setLayout(new GridLayout(orbitals.length, 1));

       for(int i=0;i<orbitals.length;i++) {
       	JCheckBox jcb = new JCheckBox(orbitals[i]);
           pSelector.add(jcb);
           cbOrbitals[i] = jcb;
           jcb.addItemListener(this);
       }

       JScrollPane sp = new JScrollPane(pSelector, JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED, JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);

       d = new Dimension(60, 2000);
       sp.setPreferredSize(d);
       sp.setMaximumSize(d);
       add("West", sp);

       p = new JPanel();
       p.setLayout(new BorderLayout());
       add("Center", p);

/*       try {
	        SecurityManager security = System.getSecurityManager();
	        if (security != null) {
	            security.checkWrite("frog.txt");
	        }
           miSaveGraphToFile.addActionListener(this);
           miSaveGraphToFile.setActionCommand("FileSaveModel");
           pmContext.add(miSaveGraphToFile);
       } catch(SecurityException e) {;}
       pmContext.setMnemonic('P');*/
   }

   private JPanel p;

	public void itemStateChanged(ItemEvent e){
      	if(cbRealtime.isSelected()) displayOrbitals();
   }

   private boolean inDisplay = false;

	public void actionPerformed(ActionEvent e) {
       String s = e.getActionCommand();
   	if(s.equals("Update")) {
       	displayOrbitals();
/*       } else if (s.equals("FileSaveModel")) {
       	OnFileSaveModel();
			//eat me!*/
       }
   }

   public void setAtom(PanelEvent pe) {
   	iAtomicNumber = pe.getElement().AtomicNumber;
   	int lower = 0;

       for(int i=0;i<cbOrbitals.length;i++) {
       	cbOrbitals[i].setEnabled( lower < iAtomicNumber );
           lower += iOrbitals[i];
       }

   	if(!activated) return;
     	if(cbRealtime.isSelected()) displayOrbitals();
   }

   private boolean activated = false;

   public void onActivate(PanelEvent pe) {
		activated = true;
//       source.addMenuToBar(pmContext);
   }

   public void onDeactivate(PanelEvent pe) {
		activated = false;
//       source.removeMenuFromBar(pmContext);
   }
   public void setColorScheme(String s){}

   public String toString() {return "Electron Animation";}

   private void displayOrbitals() {
   	if(inDisplay) return;
   	inDisplay = true;

	    Canvas3D oldC = c;

       c = new Canvas3D(null);
   	c.setBackground(new Color(0, 0, 0));
	    p.add("Center", c);

	    // Create a simple scene and attach it to the virtual universe

	    // Create the root of the branch graph
	    BranchGroup objRoot = new BranchGroup();
		BranchGroup scene = objRoot;

       // Create a Transformgroup to scale all objects so they
       // appear in the scene.
       TransformGroup objScale = new TransformGroup();
       Transform3D t3d = new Transform3D();
       // Assuming uniform size chars, set scale to fit string in view
	    t3d.setScale(0.01);
       objScale.setTransform(t3d);
       objRoot.addChild(objScale);

	    // Create the transform group node and initialize it to the
	    // identity.  Enable the TRANSFORM_WRITE capability so that
	    // our behavior code can modify it at runtime.  Add it to the
	    // root of the subgraph.
	    TransformGroup objTrans = new TransformGroup();
	    objTrans.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
	    objTrans.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
	    objScale.addChild(objTrans);

       //x axis!
       float f = 100f;
       shape = new Cylinder(0.3f, f);
       app = shape.getAppearance();
       app.setMaterial(new Material(red, black, ltRed, white, 127f));
       t = new Transform3D();
       t.rotZ(Math.PI/2);
       TransformGroup tg = new TransformGroup(t);
       tg.addChild(shape);
       objTrans.addChild(tg);

	    Font3D f3d = new Font3D(new Font("Dialog", Font.PLAIN, 12), new FontExtrusion());
	    Text3D txt = new Text3D(f3d, "X", new Point3f( f/2, 0f, 0f));
	    Shape3D sh = new Shape3D();
	    app = new Appearance();
	    Material mm = new Material();
	    mm.setLightingEnable(true);
	    app.setMaterial(mm);
	    sh.setGeometry(txt);
	    sh.setAppearance(app);
	    objTrans.addChild(sh);
       
       //y axis!
       shape = new Cylinder(0.3f, f);
       app = shape.getAppearance();
       app.setMaterial(new Material(red, black, ltRed, white, 127f));
       objTrans.addChild(shape);

	    f3d = new Font3D(new Font("Dialog", Font.PLAIN, 12), new FontExtrusion());
	    txt = new Text3D(f3d, "Y", new Point3f(0f, f/2, 0f));
	    sh = new Shape3D();
	    app = new Appearance();
	    mm = new Material();
	    mm.setLightingEnable(true);
	    app.setMaterial(mm);
	    sh.setGeometry(txt);
	    sh.setAppearance(app);
	    objTrans.addChild(sh);

       //Z axis!
       shape = new Cylinder(0.3f, f);
       app = shape.getAppearance();
       app.setMaterial(new Material(red, black, ltRed, white, 127f));
       t = new Transform3D();
       t.rotX(Math.PI/2);
       tg = new TransformGroup(t);
       tg.addChild(shape);
       objTrans.addChild(tg);

	    f3d = new Font3D(new Font("Dialog", Font.PLAIN, 12), new FontExtrusion());
	    txt = new Text3D(f3d, "Z", new Point3f(0f, 0f, f/2));
	    sh = new Shape3D();
	    app = new Appearance();
	    mm = new Material();
	    mm.setLightingEnable(true);
	    app.setMaterial(mm);
	    sh.setGeometry(txt);
	    sh.setAppearance(app);
	    objTrans.addChild(sh);

       //nucleus!
       shape = new Sphere(0.75f);
       app = shape.getAppearance();
       app.setMaterial(new Material(new Color3f(0f,0f,0f), new Color3f(0.1f,0.1f,0.1f), new Color3f(1f,1f,1f), white, 80.0f));
       objTrans.addChild(shape);

       //orbitals
       if( (cbOrbitals[0].isEnabled()) && (cbOrbitals[0].isSelected()) ) {makeOrbitalS(1, objTrans);} //1s

       if( (cbOrbitals[1].isEnabled()) && (cbOrbitals[1].isSelected()) ) {makeOrbitalS(2, objTrans);} //2s

       if( (cbOrbitals[2].isEnabled()) && (cbOrbitals[2].isSelected()) ) {makeOrbitalP(2, objTrans);} //2p

       if( (cbOrbitals[3].isEnabled()) && (cbOrbitals[3].isSelected()) ) {makeOrbitalS(3, objTrans);} //3s
       if( (cbOrbitals[4].isEnabled()) && (cbOrbitals[4].isSelected()) ) {makeOrbitalP(3, objTrans);} //3p

       if( (cbOrbitals[5].isEnabled()) && (cbOrbitals[5].isSelected()) ) {makeOrbitalS(4, objTrans);} //4s
       if( (cbOrbitals[6].isEnabled()) && (cbOrbitals[6].isSelected()) ) {makeOrbitalD(3, objTrans);} //3d
       if( (cbOrbitals[7].isEnabled()) && (cbOrbitals[7].isSelected()) ) {makeOrbitalP(4, objTrans);} //4p

       if( (cbOrbitals[8].isEnabled()) && (cbOrbitals[8].isSelected()) ) {makeOrbitalS(5, objTrans);} //5s
       if( (cbOrbitals[9].isEnabled()) && (cbOrbitals[9].isSelected()) ) {makeOrbitalD(4, objTrans);} //4d
       if( (cbOrbitals[10].isEnabled()) && (cbOrbitals[10].isSelected()) ) {makeOrbitalP(5, objTrans);} //5p

       if( (cbOrbitals[11].isEnabled()) && (cbOrbitals[11].isSelected()) ) {makeOrbitalS(6, objTrans);} //6s
       if( (cbOrbitals[12].isEnabled()) && (cbOrbitals[12].isSelected()) ) {makeOrbitalF(4, objTrans);} //4f
       if( (cbOrbitals[13].isEnabled()) && (cbOrbitals[13].isSelected()) ) {makeOrbitalD(5, objTrans);} //5d
       if( (cbOrbitals[14].isEnabled()) && (cbOrbitals[14].isSelected()) ) {makeOrbitalP(6, objTrans);} //6p

       if( (cbOrbitals[15].isEnabled()) && (cbOrbitals[15].isSelected()) ) {makeOrbitalS(7, objTrans);} //7s
       if( (cbOrbitals[16].isEnabled()) && (cbOrbitals[16].isSelected()) ) {makeOrbitalF(5, objTrans);} //5f
       if( (cbOrbitals[17].isEnabled()) && (cbOrbitals[17].isSelected()) ) {makeOrbitalD(6, objTrans);} //6d
       if( (cbOrbitals[18].isEnabled()) && (cbOrbitals[18].isSelected()) ) {makeOrbitalP(7, objTrans);} //7p

       BoundingSphere bounds = new BoundingSphere(new Point3d(0.0,0.0,0.0), 100.0);

       if (false) {
	        Transform3D yAxis = new Transform3D();
	        Alpha rotationAlpha = new Alpha(-1, Alpha.INCREASING_ENABLE,
	    	    0, 0,
	    		4000, 0, 0,
	    		0, 0, 0);

	        RotationInterpolator rotator = new RotationInterpolator(rotationAlpha, objTrans, yAxis, 0.0f, (float) Math.PI*2.0f);
	        rotator.setSchedulingBounds(bounds);
	        objRoot.addChild(rotator);
	    } else {
	        // Create the rotate behavior node
	        MouseRotate behavior = new MouseRotate();
	        behavior.setTransformGroup(objTrans);
	        objRoot.addChild(behavior);
	        behavior.setSchedulingBounds(bounds);

	        // Create the zoom behavior node
	        MouseZoom behavior2 = new MouseZoom();
	        behavior2.setTransformGroup(objTrans);
	        objRoot.addChild(behavior2);
	        behavior2.setSchedulingBounds(bounds);

	        // Create the translate behavior node
	        MouseTranslate behavior3 = new MouseTranslate();
	        behavior3.setTransformGroup(objTrans);
	        objRoot.addChild(behavior3);
	        behavior3.setSchedulingBounds(bounds);
	    }

       // Set up the background
       Color3f bgColor = new Color3f(0.0f, 0.0f, 0.0f);
       Background bgNode = new Background(bgColor);
       bgNode.setApplicationBounds(bounds);
       objRoot.addChild(bgNode);

       // Set up the ambient light
       Color3f ambientColor = new Color3f(0.1f, 0.1f, 0.1f);
       AmbientLight ambientLightNode = new AmbientLight(ambientColor);
       ambientLightNode.setInfluencingBounds(bounds);
       objRoot.addChild(ambientLightNode);

       // Set up the directional lights
       Color3f light1Color = new Color3f(1.0f, 1.0f, 0.9f);
       Vector3f light1Direction  = new Vector3f(4.0f, -7.0f, -12.0f);
       Color3f light2Color = new Color3f(0.3f, 0.3f, 0.4f);
       Vector3f light2Direction  = new Vector3f(-6.0f, -2.0f, -1.0f);

       DirectionalLight light1
           = new DirectionalLight(light1Color, light1Direction);
       light1.setInfluencingBounds(bounds);
       objRoot.addChild(light1);

       DirectionalLight light2
           = new DirectionalLight(light2Color, light2Direction);
       light2.setInfluencingBounds(bounds);
       objRoot.addChild(light2);

	    SimpleUniverse u = new SimpleUniverse(c);
       // This will move the ViewPlatform back a bit so the
       // objects in the scene can be viewed.
       u.getViewingPlatform().setNominalViewingTransform();
	    u.addBranchGraph(scene);
       c.invalidate();

       if(oldC != null) p.remove(oldC);

		inDisplay = false;
       p.invalidate();
       p.validate();
   }
                                    //      null  1st   2nd    3rd    4th    5th     6th     7th
   private static final float[] fRadiiS =  {0.0f, 1.0f, 1.75f, 3.06f, 5.36f, 9.38f,  15.94f, 27.90f};
   private static final float[] fRadiiP =  {0.0f, 0.0f, 1.75f, 3.06f, 5.36f, 9.38f,  15.94f, 27.90f};
   private static final float[] fOffsetD = {0.0f, 0.0f,  0.0f, 5.36f, 9.38f, 15.94f, 27.90f};
   private static final float[] fOffsetF = {0.0f, 0.0f,  0.0f,  0.0f, 16.25f, 28.25f};

   private void makeOrbitalS(int orbital, Group objTrans) {
   	Primitive shape = new Sphere(fRadiiS[orbital]);
       app = shape.getAppearance();
       app.setMaterial(new Material(new Color3f(0.2f,0.1f,0f), new Color3f(0f,0f,0f), new Color3f(1f,0.5f,0f), white, 80.0f));
       objTrans.addChild(shape);
   }

   private void makeOrbitalP(int orbital, Group objTrans) {
       float fRadius = fRadiiP[orbital];

       shape = new Sphere(fRadius);
       app = shape.getAppearance();
       app.setMaterial(new Material(new Color3f(0f,0f,0.1f), new Color3f(0f,0f,0f), new Color3f(0f,0f,1f), white, 80.0f));
      	t = new Transform3D();
       t.set(new Vector3d(-fRadius/2, 0, 0));
       objTranz = new TransformGroup(t);
       objTranz.addChild(shape);
       objTrans.addChild(objTranz);

       shape = new Sphere(fRadius);
       app = shape.getAppearance();
       app.setMaterial(new Material(new Color3f(0f,0f,0.1f), new Color3f(0f,0f,0f), new Color3f(0f,0f,1f), white, 80.0f));
      	t = new Transform3D();
       t.set(new Vector3d(fRadius/2, 0, 0));
       objTranz = new TransformGroup(t);
       objTranz.addChild(shape);
       objTrans.addChild(objTranz);

       shape = new Sphere(fRadius);
       app = shape.getAppearance();
       app.setMaterial(new Material(new Color3f(0f,0f,0.1f), new Color3f(0f,0f,0f), new Color3f(0f,0f,1f), white, 80.0f));
      	t = new Transform3D();
       t.set(new Vector3d(0, -fRadius/2, 0));
       objTranz = new TransformGroup(t);
       objTranz.addChild(shape);
       objTrans.addChild(objTranz);

       shape = new Sphere(fRadius);
       app = shape.getAppearance();
       app.setMaterial(new Material(new Color3f(0f,0f,0.1f), new Color3f(0f,0f,0f), new Color3f(0f,0f,1f), white, 80.0f));
      	t = new Transform3D();
       t.set(new Vector3d(0, fRadius/2, 0));
       objTranz = new TransformGroup(t);
       objTranz.addChild(shape);
       objTrans.addChild(objTranz);

       shape = new Sphere(fRadius);
       app = shape.getAppearance();
       app.setMaterial(new Material(new Color3f(0f,0f,0.1f), new Color3f(0f,0f,0f), new Color3f(0f,0f,1f), white, 80.0f));
      	t = new Transform3D();
       t.set(new Vector3d(0, 0, -fRadius/2));
       objTranz = new TransformGroup(t);
       objTranz.addChild(shape);
       objTrans.addChild(objTranz);

       shape = new Sphere(fRadius);
       app = shape.getAppearance();
       app.setMaterial(new Material(new Color3f(0f,0f,0.1f), new Color3f(0f,0f,0f), new Color3f(0f,0f,1f), white, 80.0f));
      	t = new Transform3D();
       t.set(new Vector3d(0, 0, fRadius/2));
       objTranz = new TransformGroup(t);
       objTranz.addChild(shape);
       objTrans.addChild(objTranz);
   }

   private void makeOrbitalD(int orbital, Group objTrans) {
   	float fOffset = fOffsetD[orbital];
       float fRadius = 2.0f;
       Transform3D t;
       TransformGroup tg, tgg;

       QuadCone qc = new QuadCone(fRadius, fOffset, black, black, ltGreen, white, 80.0f);
       objTrans.addChild(qc);

       qc = new QuadCone(fRadius, fOffset, black, black, ltGreen, white, 80.0f);
       t = new Transform3D();
       t.rotZ(Math.PI/4);
       tg = new TransformGroup(t);
       tg.addChild(qc);
       objTrans.addChild(tg);

       qc = new QuadCone(fRadius, fOffset, black, black, ltGreen, white, 80.0f);
       t = new Transform3D();
       t.rotY(Math.PI/2);
       tg = new TransformGroup(t);
       tg.addChild(qc);
       t = new Transform3D();
       t.rotX(Math.PI/4);
       tgg = new TransformGroup(t);
       tgg.addChild(tg);
       objTrans.addChild(tgg);

       qc = new QuadCone(fRadius, fOffset, black, black, ltGreen, white, 80.0f);
       t = new Transform3D();
       t.rotX(Math.PI/2);
       tg = new TransformGroup(t);
       tg.addChild(qc);
       t = new Transform3D();
       t.rotY(Math.PI/4);
       tgg = new TransformGroup(t);
       tgg.addChild(tg);
       objTrans.addChild(tgg);

       IceCreamCone icc = new IceCreamCone(fRadius, fOffset, black, black, ltGreen, white, 80.0f);
       t = new Transform3D();
       t.rotX(Math.PI/2);
       tg = new TransformGroup(t);
       tg.addChild(icc);
       objTrans.addChild(tg);

       icc = new IceCreamCone(fRadius, fOffset, black, black, ltGreen, white, 80.0f);
       t = new Transform3D();
       t.rotX(-Math.PI/2);
       tg = new TransformGroup(t);
       tg.addChild(icc);
       objTrans.addChild(tg);

       Cylinder cyl = new Cylinder(fRadius * 1.5f, fOffset / 5f);
       app = cyl.getAppearance();
       app.setMaterial(new Material(black, black, ltGreen, white, 80.0f));
       t = new Transform3D();
       t.rotX(-Math.PI/2);
       tg = new TransformGroup(t);
       tg.addChild(cyl);
       objTrans.addChild(tg);
   }

   private void makeOrbitalF(int orbital, Group objTrans) {
   	float fOffset = fOffsetF[orbital];
       float fRadius = 1f;
       OctaCone oc;
       TransformGroup tg, tgg;

       BiCone bc = new BiCone(fRadius, fOffset, new Color3f(0.6f, 0f, 0.6f), black, purple, white, 127.0f);

       Cylinder cyl = new Cylinder(fRadius * 1.5f, fOffset / 5f);
       app = cyl.getAppearance();
       app.setMaterial(new Material(new Color3f(0.6f, 0f, 0.6f), black, purple, white, 127.0f));
       objTrans.addChild(cyl);

       bc = new BiCone(fRadius, fOffset, new Color3f(0.6f, 0f, 0.6f), black, purple, white, 127.0f);
       t = new Transform3D();
       t.rotZ(Math.PI/2);
       tg = new TransformGroup(t);
       tg.addChild(bc);
       objTrans.addChild(tg);

       cyl = new Cylinder(fRadius * 1.5f, fOffset / 5f);
       app = cyl.getAppearance();
       app.setMaterial(new Material(new Color3f(0.6f, 0f, 0.6f), black, purple, white, 127.0f));
       t = new Transform3D();
       t.rotZ(Math.PI/2);
       tg = new TransformGroup(t);
       tg.addChild(cyl);
       objTrans.addChild(tg);

       bc = new BiCone(fRadius, fOffset, new Color3f(0.6f, 0f, 0.6f), black, purple, white, 127.0f);
       t = new Transform3D();
       t.rotX(Math.PI/2);
       tg = new TransformGroup(t);
       tg.addChild(bc);
       objTrans.addChild(tg);

       cyl = new Cylinder(fRadius * 1.5f, fOffset / 5f);
       app = cyl.getAppearance();
       app.setMaterial(new Material(new Color3f(0.6f, 0f, 0.6f), black, purple, white, 127.0f));
       t = new Transform3D();
       t.rotX(Math.PI/2);
       tg = new TransformGroup(t);
       tg.addChild(cyl);
       objTrans.addChild(tg);

       oc = new OctaCone(fRadius, fOffset, new Color3f(0.6f, 0f, 0.6f), black, purple, white, 127.0f);
       t = new Transform3D();
       t.rotY(Math.PI/4);
       tg = new TransformGroup(t);
       tg.addChild(oc);
       objTrans.addChild(tg);

       oc = new OctaCone(fRadius, fOffset, new Color3f(0.6f, 0f, 0.6f), black, purple, white, 127.0f);
       t = new Transform3D();
       t.rotZ(Math.PI/4);
       tg = new TransformGroup(t);
       tg.addChild(oc);
       objTrans.addChild(tg);

       oc = new OctaCone(fRadius, fOffset, new Color3f(0.6f, 0f, 0.6f), black, purple, white, 127.0f);
       t = new Transform3D();
       t.rotZ(Math.PI/4);
       tg = new TransformGroup(t);
       tg.addChild(oc);
       t = new Transform3D();
       t.rotY(Math.PI/2);
       tgg = new TransformGroup(t);
       tgg.addChild(tg);
       objTrans.addChild(tgg);

       oc = new OctaCone(fRadius, fOffset, new Color3f(0.6f, 0f, 0.6f), black, purple, white, 127.0f);
       t = new Transform3D();
       t.rotY(Math.PI/4);
       tg = new TransformGroup(t);
       tg.addChild(oc);
       objTrans.addChild(tg);
   }

/*   private void OnFileSaveModel() {
     try {
	    SimpleFileFilter filter = new SimpleFileFilter("bmp", "Windows Bitmap");
       String fname = DoFileDialog.GetFileName(this, "Save Model Image...", FileDialog.SAVE, filter);
       if(fname.equals("")) return;

       try {
	        SecurityManager security = System.getSecurityManager();
	        if (security != null) {
	            security.checkWrite(fname);
	        }
       } catch(SecurityException e) {
           JOptionPane.showMessageDialog(this,
               "The Java Browser has restricted me from saving files.  You will need to either run this program as an application from a command line, or release those restrictions.",
               "Security Restriction!",
               JOptionPane.ERROR_MESSAGE);
           return;
       }

       Dimension size = c.getSize();
       BufferedImage iBuffer = new BufferedImage(size.width, size.height, BufferedImage.TYPE_3BYTE_BGR);
       Graphics2D g2 = iBuffer.createGraphics();
       c.paint(g2);

       BitmapFile bf = new BitmapFile(this);
       Dimension d = getSize();
       if(iBuffer == null) repaint();
       bf.saveBitmap(fname, iBuffer, d.width, d.height);
     } catch (Exception e){
       e.printStackTrace();
     }
   }*/

   public void setStyle(PanelEvent pe) {}   
}
