/* gifserv -- simple 1x1 transparent gif HTTP server used for ad zapping */
#include <unistd.h>
#include <stdio.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <stdlib.h>
#include <string.h>
#include <sys/time.h>
#include <time.h>

static const char *header = 
	"HTTP/1.0 200 OK\r\nExpires: Sat, 1 Feb 2025 00:00:00 GMT\r\nLast-Modified: Sat, 1 Nov 1980 08:30:15 GMT\r\nContent-Length: 43\r\nETag: 0\r\nContent-type: image/gif\r\n";
static int header_len;

#define DATEBUF_LEN 256
static char datebuf[DATEBUF_LEN];
static int datebuf_len;

static const char gif[] =
	{ 0x47, 0x49, 0x46, 0x38, 0x39, 0x61, 0x01, 0x00, 0x01, 0x00, 0x80,
	  0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x21, 0xf9, 0x04,
	  0x01, 0x00, 0x00, 0x01, 0x00, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x01,
	  0x00, 0x01, 0x00, 0x00, 0x02, 0x02, 0x4c, 0x01, 0x00, 0x3b };
static const int gif_len = 43;

#define BUFFER_LEN 512
static char ignore[BUFFER_LEN];

int main(int argc, char *argv[])
{
	int sock_listen, sock_conn, conaddr_len;
	struct sockaddr_in saddr;
	struct sockaddr conaddr_in;
	struct timeval tv;
	struct tm *tm_p;

	header_len = strlen(header);

	if (argc != 3) {
		printf("Usage: %s <IP Address> <TCP port>\n", argv[0]);
		exit(1);
	}

	if (inet_aton(argv[1], &saddr.sin_addr) == 0) {
		printf("Invalid IP address.\n");
		exit(1);
	}

	saddr.sin_family = AF_INET;
	saddr.sin_port = htons(atoi(argv[2]));

	sock_listen = socket(PF_INET, SOCK_STREAM, IPPROTO_TCP);

	if (bind(sock_listen, (struct sockaddr *)&saddr, sizeof(saddr))) {
		perror("bind");
		exit(1);
	}

	if (listen(sock_listen, 4)) {
		perror("listen");
		exit(1);
	}

	ioctl(0, TIOCNOTTY, NULL);

	if (fork() != 0) {
		exit(0);
	}

	close(0);
	close(1);
	close(2);

	while(1) {
		sock_conn = accept(sock_listen, &conaddr_in, &conaddr_len);
		while (recv(sock_conn, ignore, BUFFER_LEN, 0) ==  BUFFER_LEN);
		gettimeofday(&tv, NULL);
		tm_p = gmtime(&tv.tv_sec);
		datebuf_len = strftime(datebuf, DATEBUF_LEN, "Date: %a, %e %b %Y %T %Z\r\n", tm_p);
		send(sock_conn, header, header_len, 0);
		send(sock_conn, datebuf, datebuf_len, 0);
		send(sock_conn, "\r\n", 2, 0);
		send(sock_conn, gif, gif_len, 0);
		close(sock_conn);
	}
}

