import java.util.*;
import java.security.*;
import java.io.*;

public class Babelizer {
	private BabelInfo bi;
   public static final String crlf = System.getProperty("line.separator");

   public static void babelize(BabelInfo bi) throws Exception {
   	Babelizer b = new Babelizer(bi);
       b.playGod();
   }

	public Babelizer(BabelInfo b) {
   	bi = b;
   }

   public void playGod() throws Exception {
   	System.out.println("\nBabelizer Engine v3.91 by Echo.");

       FileInputStream seed;
       try {seed = new FileInputStream(bi.seed);} catch(Exception e) {System.err.println("I cannot find seed file \""+bi.seed+"\"."); return;}
       File f = new File(bi.seed);
       byte[] bSeed = new byte[(int)f.length()-1];
		seed.read(bSeed);
       seed.close();

       bi.seed2 ^= System.currentTimeMillis();
       for(int i=0;i<bSeed.length;i++) bSeed[i] ^= bi.seed2;

       System.out.println("Generating random number with "+bSeed.length+" byte seed...");
       MySecureRandom msr = new MySecureRandom(bSeed);

       FileInputStream source;
       try {source = new FileInputStream(bi.source);} catch(Exception e) {System.err.println("I cannot find source \""+bi.source+"\"."); return;}
       BufferedReader brSource = new BufferedReader(new InputStreamReader(source));

       FileWriter fwDest = new FileWriter((bi.dump));

       if(bi.hasHeader) {
       	FileInputStream header;
       	try {header = new FileInputStream(bi.header);} catch(Exception e) {System.err.println("I cannot find header \""+bi.header+"\"."); return;}
       	BufferedReader brHeader = new BufferedReader(new InputStreamReader(header));

           String s;
       	while( (s = brHeader.readLine()) != null) {
           	fwDest.write(s);
               fwDest.write(crlf);
       	}
           header.close();
       }

		System.out.println("Now reading lines from the file..."); System.out.flush();
       Vector lines = new Vector(5000, 1000);
       String s;
       int counter = 0;
       while( (s = brSource.readLine()) != null) {
       	System.out.print("Reading line: "+counter+"...\r");
       	if(s.equals("")) continue; //skip empty lines...
       	lines.addElement(s);
           counter++;
       }
       System.out.println("Done reading...start writing!");
       int linesRead = counter;

       int maxLines = lines.size();
       maxLines--; //just in case!
       counter = 0;

       if(bi.numLines < 0) bi.numLines = linesRead;
       while(counter <= bi.numLines) {
       	System.out.print("Writing line: "+counter+" of "+bi.numLines+"...\r");
           System.out.flush();
           //first get random number...
/*           double d = Math.random() * maxLines;
			int line = (int)Math.round(d);
*/
			long rnd = Math.abs(msr.random() ^ System.currentTimeMillis());
           int line = Math.round((float)rnd / Long.MAX_VALUE * (float)maxLines);
           String x = (String)lines.elementAt(line);
           fwDest.write(x);
           fwDest.write(crlf);
           fwDest.flush();
       	counter++;
       }

       System.out.println("Finished writing...                              ");

       if(bi.hasFooter) {
       	FileInputStream footer;
       	try {footer = new FileInputStream(bi.footer);} catch(Exception e) {System.err.println("I cannot find footer \""+bi.footer+"\"."); return;}
       	BufferedReader brFooter = new BufferedReader(new InputStreamReader(footer));

       	while( (s = brFooter.readLine()) != null) {
           	fwDest.write(s);
               fwDest.write(crlf);
       	}
       	footer.close();
       }

       //AT THE END, CLOSE ALL FILES!!!!!
       fwDest.close();
       source.close();
   }
}

class MySecureRandom extends SecureRandom {
	public MySecureRandom() {super();}
   public MySecureRandom(byte[] b) {super(b);}
   public int random(int strength) {return next(strength);}
   public long random() {return nextLong();}
}