import java.io.*;
import java.net.*;

public class SimpleDatagramClient
{
    private DatagramSocket socket = null;
    private DatagramPacket recvPacket, sendPacket;
    private int hostPort;

    public static void main(String[] args)
    {
        DatagramSocket socket = null;
        DatagramPacket recvPacket, sendPacket;
        int hostPort;
        if ( args.length > 0)
        {
            hostPort = Integer.valueOf(args[1]).intValue();
        }
        else
        {
            hostPort = 4545;
        }
        try
        {
            socket = new DatagramSocket();
            InetAddress hostAddress = InetAddress.getByName(args[0]);
            BufferedReader userData = new BufferedReader(
				new InputStreamReader(System.in) );
            while (socket != null)
            {
                String userString = userData.readLine();
                if (userString == null || userString.equals(""))
                    return;
    			byte sendbuf[] = userString.getBytes();
	            sendPacket = new DatagramPacket(
                    sendbuf, sendbuf.length, hostAddress, hostPort );
                socket.send( sendPacket );
                recvPacket= new DatagramPacket(new byte[512], 512);
                socket.receive(recvPacket);
                System.out.write(recvPacket.getData(), 0,
                    recvPacket.getLength());
                System.out.print("\r\n");
            }
        }
        catch (SocketException se)
        {
            System.out.println("Error in SimpleDatagramClient: " + se);
        }
        catch (IOException ioe)
        {
            System.out.println("Error in SimpleDatagramClient: " + ioe);
        }
    }
}
