import java.io.*;
import java.net.*;

public class SimpleDatagramServer
{
    public static void main(String[] args)
    {
        DatagramSocket socket = null;
        DatagramPacket recvPacket, sendPacket;
        int hostPort;
        if ( args.length > 0 )
        {
            hostPort = Integer.valueOf(args[0]).intValue();
        }
        else
        {
            hostPort = 4545;
        }
        try
        {
            socket = new DatagramSocket(hostPort);
            while (socket != null)
            {
                recvPacket= new DatagramPacket(new byte[512], 512);
                socket.receive(recvPacket);
                sendPacket = new DatagramPacket(
                    recvPacket.getData(), recvPacket.getLength(),
                    recvPacket.getAddress(), recvPacket.getPort() );
                socket.send( sendPacket );

                System.out.write(recvPacket.getData(), 0,
                    recvPacket.getLength());
                System.out.print("\r\n");
            }
        }
        catch (SocketException se)
        {
            System.out.println("Error in SimpleDatagramServer: " + se);
        }
        catch (IOException ioe)
        {
            System.out.println("Error in SimpleDatagramServer: " + ioe);
        }
    }
}
