import javax.swing.*;
import javax.swing.border.*;
import java.util.*;
import java.awt.*;

public class JIPAddress extends JPanel {
   private JTextField p1, p2, p3, p4;

   public JIPAddress() {
       setLayout(new BoxLayout(this, BoxLayout.X_AXIS));
       p1 = new JTextField("209", 4);
       p2 = new JTextField("0", 4);
       p3 = new JTextField("131", 4);
       p4 = new JTextField("6", 4);

       Font f = new Font("Courier", Font.BOLD, 14);
       setBorder(p1.getBorder());
       setBackground(Color.white);
       p1.setBorder(null);p1.setFont(f);p1.setHorizontalAlignment(JTextField.CENTER);
       p2.setBorder(null);p2.setFont(f);p2.setHorizontalAlignment(JTextField.CENTER);
       p3.setBorder(null);p3.setFont(f);p3.setHorizontalAlignment(JTextField.CENTER);
       p4.setBorder(null);p4.setFont(f);p4.setHorizontalAlignment(JTextField.CENTER);

       JLabel l1, l2, l3, l4;
       l1 = new JLabel(".");l1.setBackground(Color.white);
       l2 = new JLabel(".");l2.setBackground(Color.white);
       l3 = new JLabel(".");l3.setBackground(Color.white);

       add(p1);add(l1);
       add(p2);add(l2);
       add(p3);add(l3);
       add(p4);
   }

   public JIPAddress(long x) {
       this();
       setAddress(x);
   }

   public JIPAddress(String x) {
       this();
       setAddress(x);
   }

   public void setEnabled(boolean b) {
       super.setEnabled(b);
       if(p1 != null) p1.setEnabled(b);
       if(p2 != null) p2.setEnabled(b);
       if(p3 != null) p3.setEnabled(b);
       if(p4 != null) p4.setEnabled(b);
   }

   public String getAddressAsString() {
       String part1 = IPAddressUtils.truncate(p1.getText());
       String part2 = IPAddressUtils.truncate(p2.getText());
       String part3 = IPAddressUtils.truncate(p3.getText());
       String part4 = IPAddressUtils.truncate(p4.getText());

       return part1 + "." + part2 + "." + part3 + "." + part4;
   }

   public long getAddressAsLong() {
       long part1 = Long.parseLong( IPAddressUtils.truncate(p1.getText()) );
       long part2 = Long.parseLong( IPAddressUtils.truncate(p2.getText()) );
       long part3 = Long.parseLong( IPAddressUtils.truncate(p3.getText()) );
       long part4 = Long.parseLong( IPAddressUtils.truncate(p4.getText()) );

       return (part1 << 24) + (part2 << 16) + (part3 << 8) + (part4);

       // 11010001000000001000001100000110
       // 11010001 00000000 10000011 00000110
       // 1101 0001 0000 0000 1000 0011 0000 0110
   }

   public void setAddress(String x) {
       StringTokenizer st = new StringTokenizer(x, ".", false);

       p1.setText(st.nextToken());
       p2.setText(st.nextToken());
       p3.setText(st.nextToken());
       p4.setText(st.nextToken());
   }

   public void setAddress(long x) {
       setAddress(IPAddressUtils.getLongAsString(x));
   }
}
