package grid.manager;

import grid.util.Defaults;
import java.rmi.Naming;
import java.rmi.registry.Registry;
import java.rmi.registry.LocateRegistry;

public class Main {
	public static void main(String args[]) {
		String name = "//./"+Defaults.managerService;
		System.setSecurityManager(new java.rmi.RMISecurityManager());

		try {
			Manager man = new Manager();
			Naming.rebind(name, man);
			System.out.println("Bound manager as "+name);
		} catch (Exception e) {
			System.out.println("BAH!");
			if(!(e instanceof java.rmi.ConnectException)) {
				e.printStackTrace();
			}

			//try creating registry
			if(args == null) System.exit(0);
			
			try {
				Registry registry = LocateRegistry.createRegistry(1099);
			} catch (Exception x) {
				x.printStackTrace();
				System.exit(0);
			}
			main(null);
		}

		//now what?
		/*
		while(true) {
			try {Thread.sleep(1000);} catch (Exception e) {;}
		}
		*/
	}
}
