/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import javax.swing.tree.DefaultMutableTreeNode;

class AttributeItem
implements ElementInfo {
    int type_index;
    int length;
    String id;
    ConstantPoolInfo constants;

    public DefaultMutableTreeNode Describe() {
        return new DefaultMutableTreeNode(this.id + " [" + this.length + " bytes]");
    }

    public static AttributeItem extractAttribute(ConstantPoolInfo constantPoolInfo, DataInputStream dataInputStream) {
        String string;
        int n;
        try {
            n = dataInputStream.readUnsignedShort();
            string = constantPoolInfo.getUtf8(n);
        }
        catch (IOException iOException) {
            n = -1;
            string = "Error";
        }
        AttributeItem attributeItem = string.equals("ConstantValue") ? new ConstantValueAttr(constantPoolInfo, n, string, dataInputStream) : (string.equals("SourceFile") ? new SourceFileAttr(constantPoolInfo, n, string, dataInputStream) : (string.equals("Code") ? new CodeAttr(constantPoolInfo, n, string, dataInputStream) : (string.equals("Exceptions") ? new ExceptionsAttr(constantPoolInfo, n, string, dataInputStream) : (string.equals("LineNumberTable") ? new LineNumberTableAttr(constantPoolInfo, n, string, dataInputStream) : (string.equals("LocalVariableTable") ? new LocalVariableTableAttr(constantPoolInfo, n, string, dataInputStream) : (string.equals("Error") ? new AttributeItem() : new AttributeItem(constantPoolInfo, n, string, dataInputStream)))))));
        return attributeItem;
    }

    public AttributeItem(ConstantPoolInfo constantPoolInfo, int n, String string, DataInputStream dataInputStream) {
        this.constants = constantPoolInfo;
        this.type_index = n;
        this.id = string;
        try {
            this.length = dataInputStream.readInt();
            dataInputStream.skipBytes(this.length);
        }
        catch (IOException iOException) {
            System.out.println("" + iOException);
        }
    }

    public AttributeItem() {
        this.type_index = -1;
        this.length = 0;
        this.id = "Error";
    }
}

