import java.io.*;
import javax.swing.tree.*;

public class FieldInfo implements ElementInfo
{
	int count;
	ConstantPoolInfo constants;
	FieldItem fields[];
	boolean expanded = false;
	StatusKeeper stats;

	public FieldInfo(ConstantPoolInfo c, DataInputStream is, StatusKeeper y)
	{
		try
		{
			stats = y;
			constants = c;
			count = is.readUnsignedShort();
			if ( count != 0 )
			{
				fields = new FieldItem[count];
				for ( int x = 0; x < count; x++ )
					fields[x] = new FieldItem(c, is, stats, x);
			}
		}
		catch (IOException ioe)
		{
			System.out.println("" + ioe);
		}
	}

	public DefaultMutableTreeNode Describe() {
		DefaultMutableTreeNode result = new DefaultMutableTreeNode("Fields: "+count+" items.");

		for ( int x = 0; x < count; x++ )
			result.add(fields[x].Describe());

		return result;
	}
}

class FieldItem implements ElementInfo
{
	int access_flags;
	int name_index;
	String name;
	int signature_index;
	ConstantPoolInfo constants;
	AttributeInfo attributes;
	StatusKeeper stats;
	int num;

	public FieldItem(ConstantPoolInfo c, DataInputStream is, StatusKeeper x, int y)
	{
		try
		{
			num = y;
			stats = x;
			constants = c;
			access_flags = is.readUnsignedShort();
			name_index = is.readUnsignedShort();
			name = c.getUtf8(name_index);
			signature_index = is.readUnsignedShort();
			attributes = new AttributeInfo(c, is);
		}
		catch (IOException ioe)
		{
			System.out.println("" + ioe);
		}
	}

	public DefaultMutableTreeNode Describe() {
		stats.setProgressText("Processing field \""+name+"\"...", num);   
		DefaultMutableTreeNode result = new DefaultMutableTreeNode(name);
		result.add(new DefaultMutableTreeNode(constants.getUtf8(signature_index)));
		result.add(new DefaultMutableTreeNode(ClassReader.listAccessFlags(access_flags)));
		result.add(attributes.Describe()); //Yuck!
		return result;
	}
}
