//This is v3 of the stupid Java Class Browser...
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import javax.swing.*;
import javax.swing.filechooser.*;
import javax.swing.tree.*;
import javax.swing.event.*;

public class JBrowser extends JFrame implements WindowListener, ActionListener {
	//Variables
	JMenuItem miFileOpen, miSaveAll, miFileExit, miSaveNode;
	JMenuBar mb = new JMenuBar();
	JMenu mFile = new JMenu("File");
	JTree tClassTree;
	JScrollPane spMain;
	JPanel tbMain = new JPanel(new FlowLayout(FlowLayout.LEFT), true);
	JButton btnOpen, btnSaveAll, btnExit, btnSaveNode;

	JLabel lStatus = new JLabel("Click \"Open\" to browse a class file.");
	ProgressDlg pd = new ProgressDlg((Frame)this, "Current Task", "Total Progress");

	//WindowListener
	public void windowActivated(WindowEvent e) {}
	public void windowDeactivated(WindowEvent e) {}
	public void windowIconified(WindowEvent e) {}
	public void windowDeiconified(WindowEvent e) {}
	public void windowOpened(WindowEvent e) {}
	public void windowClosed(WindowEvent e) {}
	public void windowClosing(WindowEvent e) {System.exit(0);}

	public void actionPerformed(ActionEvent e){
		String s = e.getActionCommand();
		if(s.equals("Open")) OnOpenFile();
		else if(s.equals("Save")) OnSaveFile();
		else if(s.equals("Save Branch")) OnSaveNode();
		else if(s.equals("Exit")) System.exit(0);
	}

	//The meat of the app
	static public void main(String args[])
	{
		(new JBrowser("Java Class Browser")).setVisible(true);
	}

	public JBrowser(String s){
		//do window initing
		super(s);
		addWindowListener(this);
		getContentPane().setLayout(new BorderLayout());

		//set up menus
		miFileOpen = new JMenuItem("Open", 'O');

		mFile.add(miFileOpen);

		miSaveAll = new JMenuItem("Save", 'S');
		miSaveAll.addActionListener(this);
		mFile.add(miSaveAll);

		miSaveNode = new JMenuItem("Save Branch", 'N');
		miSaveNode.addActionListener(this);
		mFile.add(miSaveNode);

		miFileExit = new JMenuItem("Exit", 'x');
		miFileExit.addActionListener(this);
		mFile.add(miFileExit);

		mFile.setMnemonic('F');
		mb.add(mFile);
		setJMenuBar(mb);

		//resize
		Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
		setSize((d.width * 3) / 4, (d.height * 3) / 4);
		Dimension b = getSize();
		setLocation((d.width - b.width) / 2, (d.height - b.height) / 2);

		//set up tree view & scroll pane
		tClassTree = new JTree(SetupTreeView());
		tClassTree.setFont(new Font("Monospaced", 0, 12));
		tClassTree.setEditable(false);

		spMain = new JScrollPane(tClassTree);
		getContentPane().add("Center", spMain);

		//init Toolbar
		btnOpen = new JButton("Open");
		btnOpen.addActionListener(this);
		tbMain.add(btnOpen);

		btnSaveAll = new JButton("Save");
		btnSaveAll.addActionListener(this);
		btnSaveAll.setEnabled(false);
		tbMain.add(btnSaveAll);

		btnSaveNode = new JButton("Save Branch");
		btnSaveNode.addActionListener(this);
		btnSaveNode.setEnabled(false);
		tbMain.add(btnSaveNode);

		btnExit = new JButton("Exit");
		btnExit.addActionListener(this);
		tbMain.add(btnExit);

		getContentPane().add("North", tbMain);
		getContentPane().add("South", lStatus);
	}

	private DefaultMutableTreeNode SetupTreeView() {
		DefaultMutableTreeNode top = new DefaultMutableTreeNode("Click \"Open\" to browse a class...");
		return top;
	}

	private void OnOpenFile(){
		SimpleFileFilter filter = new SimpleFileFilter("class", "Java Class Files");

		String s = DoFileDialog.GetFileName((Frame) this, "Open a class for browsing", FileDialog.LOAD, filter);
		if(!s.equals("") ) {
			pd.showProgress();
			ClassReader c = new ClassReader(s, tClassTree, pd.getKeeper2(), pd.getKeeper1());
			btnSaveAll.setEnabled(true);
			btnSaveNode.setEnabled(true);
		}
	}

	private void OnSaveFile(){
		SimpleFileFilter filter = new SimpleFileFilter("txt", "Class Profiles");

		String s = DoFileDialog.GetFileName((Frame) this, "Save a class profile", FileDialog.SAVE, filter);
		if(!s.equals("") ) {
			pd.showProgress();
			TreeSaver c = new TreeSaver(s, tClassTree, pd.getKeeper1());
			c.saveRoot();
			pd.hideProgress();
		}
	}

	private void OnSaveNode(){
		SimpleFileFilter filter = new SimpleFileFilter("txt", "Class Profile Branch");

		String s = DoFileDialog.GetFileName((Frame) this, "Save a branch", FileDialog.SAVE, filter);
		if(!s.equals("") ) {
			pd.showProgress();
			TreeSaver c = new TreeSaver(s, tClassTree, pd.getKeeper1());
			TreePath p = tClassTree.getSelectionPath();
			c.saveNode((DefaultMutableTreeNode)p.getLastPathComponent());
			pd.hideProgress();
		}
	}
}

class ProgressDlg extends JDialog implements ActionListener {
	private JProgressBar p1, p2;
	private JLabel l1, l2;
	private JCheckBox cbSecondary = new JCheckBox("Follow Secondary Progress", false);
	private StatusKeeper s1, s2;

	public ProgressDlg(Frame parent, String x, String x2){
		super(parent, "Progress");
		setVisible(false);
		p1 = new JProgressBar(); p2 = new JProgressBar();
		l1 = new JLabel(x); l2 = new JLabel(x2);
		GridLayout g = new GridLayout(5,1);
		g.setVgap(10);
		getContentPane().setLayout(g);
		getContentPane().add(l1); getContentPane().add(p1);
		cbSecondary.addActionListener(this);
		getContentPane().add(cbSecondary);
		getContentPane().add(l2); getContentPane().add(p2);
		s1 = new StatusKeeper(p1, l1, false, this); s2 = new StatusKeeper(p2, l2, true, this);
	}

	public void actionPerformed(ActionEvent e) {
		if(e.getSource() == cbSecondary) {
			if(cbSecondary.isSelected()){
				s1.setEnabled(true);
			} else {
				s1.setEnabled(false);
			}
		}
	}

	public void showProgress() {
		//center...
		Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
		setSize((d.width) / 4, 150);//(d.height * 3) / 4);
		Dimension b = getSize();
		setLocation((d.width - b.width) / 2, (d.height - b.height) / 2);
		setVisible(true);
	}

	public void hideProgress() {
		setVisible(false);
	}

	public StatusKeeper getKeeper1() {
		return s1;
	}

	public StatusKeeper getKeeper2() {
		return s2;
	}
}
