import java.awt.*;

class Toolbar extends Panel
{
	public Toolbar()
	{
		super();
		setFont(new Font("Dialog", 0, 12));
	}

	public Toolbar(LayoutManager l)
	{
		super(l);
		setFont(new Font("Dialog", 0, 12));
	}

	public void paint(Graphics g)
	{
		super.paint(g);
		Dimension d = getSize();
		Color c = g.getColor();
		g.setColor(SystemColor.control);
		g.fill3DRect(0, 0, d.width, 2, false);
		g.setColor(c);
	}
}

class StatusBar extends Panel
{
	private String msg;
	private Font font;
	private int myHeight;

	public StatusBar(String s, Font f, int ht)
	{
		super();
		msg = s;
		font = f;
		myHeight = ht;
		repaint();
		setBackground(Color.lightGray);	   
	}

	public StatusBar(String s, Font f)
	{
		this(s, f, 22);
	}

	public StatusBar(String s)
	{
		this(s, new Font("Dialog", 0, 13), 22);
	}

	public StatusBar()
	{
		this("", new Font("Dialog", 0, 13), 22);
	}

	public Dimension getMinimumSize()
	{
		Dimension d = super.getMinimumSize();
		d.height = myHeight;
		return d;
	}

	public Dimension getPreferredSize()
	{
		Dimension d = super.getPreferredSize();
		d.height = myHeight;
		return d;
	}

/*   public void init(String m, Font f, int ht)
	{
		msg = m;
		font = f;
		if(ht == -1) ht = 22;
		myHeight = ht;
		repaint();
	}*/

	public String getText() {return msg;}
	public void setText(String m) {msg = m; repaint();}

	public Font getFont() {return font;}
	public void setFont(Font f) {font = f; repaint();}

	public void update(Graphics g) {
		super.paint(g);
		Dimension d = getSize();
		Color c = g.getColor();
		g.setColor(SystemColor.control);
		g.draw3DRect(0, 0, d.width-1, d.height-1, false);
		g.setColor(c);

		Font fnt = g.getFont();
		g.setFont(font);
		g.drawString(msg, 2, ((myHeight - font.getSize()) / 2) + font.getSize()-1);
		g.setFont(fnt);
	}

	public void paint(Graphics g) {
		update(g);
	}
}
