import java.io.*;
import javax.swing.*;
import javax.swing.tree.*;

public class TreeSaver implements Runnable {
	String fname;
	JTree tTree;
	DefaultTreeModel tmModel;

	StatusKeeper stats;

	public void run() {
	   while(true){
			stats.setProgress(Saved);
			try{
				Thread.sleep(100); //.5 seconds
			} catch (InterruptedException e) {
			}
		}
	}

	public TreeSaver(String s, JTree t, StatusKeeper x){
		fname = s;
		tTree = t;
		stats = x;
		tmModel = (DefaultTreeModel) tTree.getModel();
	}

	public void saveNode(DefaultMutableTreeNode node){
		DoExportCount(node);

		stats.setEnabled(true);
		stats.setMax(Count);
		stats.initProgressBar();
		stats.showProgressBar();
		stats.setStatus("Saving disassembly to \""+fname+"\"...");
		DoExport(node);
		stats.hideProgressBar();
		stats.setStatus("Saved disassembly to \""+fname+"\"...");
	}

	public void saveRoot(){
		DoRootExportCount();

		stats.setEnabled(true);
		stats.setMax(Count);
		stats.initProgressBar();
		stats.showProgressBar();
		stats.setStatus("Saving disassembly to \""+fname+"\"...");
		DoRootExport();
		stats.hideProgressBar();
		stats.setStatus("Saved disassembly to \""+fname+"\"...");
	}

	private void DoExport(DefaultMutableTreeNode tn){
		/*Notes:
			open file
			get root node
			call dump function
		*/

		Thread t = new Thread(this);
		t.setDaemon(true);
		t.setPriority(Thread.MIN_PRIORITY);
		t.start();

		try {
			FileOutputStream outFile = new FileOutputStream(fname);
			DataOutputStream os = new DataOutputStream(new BufferedOutputStream(outFile));
			//now get root
			DumpNode(tn, os);

			os.flush();
			outFile.close();
		} catch (IOException e) {
			e.printStackTrace();
		}
		t.interrupt();
		t = null;//.suspend();
	}

	private void DoRootExport(){
		/*Notes:
			open file
			get root node
			call dump function
		*/

		Thread t = new Thread(this);
		t.setDaemon(true);
		t.setPriority(Thread.MIN_PRIORITY);
		t.start();

		try {
			FileOutputStream outFile = new FileOutputStream(fname);
			DataOutputStream os = new DataOutputStream(new BufferedOutputStream(outFile));
			//now get root
			DefaultMutableTreeNode tnRoot = (DefaultMutableTreeNode) tmModel.getRoot();
			DumpNode(tnRoot, os);
			//now dump other root level nodes...
			DefaultMutableTreeNode tn;
			while( (tn = tnRoot.getNextSibling()) != null) {
				DumpNode(tn, os);
			}
			os.flush();
			outFile.close();
		} catch (IOException e) {
			e.printStackTrace();
		}
		t.interrupt();
		t = null;
		//t.stop();
	}

	private void DumpNode(DefaultMutableTreeNode t, DataOutputStream os) throws IOException{
		/*
			query level, dump that many "\t" and dump name
			loop thru children
				query level & dump "\t" out
				write name
				if has children, dump them!
		*/
		//dump tab chars
		int x = t.getLevel();
		for(int i = 0; i < x; i++){
			os.writeBytes("  |");
//		   os.write(' ');os.write(' ');os.write('|');
		}
		os.writeBytes("--");
//	   os.write('-');os.write('-');
		//now dump name
		String tmp = t.toString();
		os.writeBytes(tmp);
		os.writeBytes("\r\n");
/*
		x = tmp.length();
		for(int i = 0; i < x; i++){
			os.write(tmp.charAt(i));
		}*/
		Saved++;

/*	 --Frog
		  |--is
		  |--a
		  |  |--dorky
		  |  |--gorf
		  |--without
		  |--a
		  |  |--brain*/

//	   os.write('\r');os.write('\n');
		if(t.getChildCount() == 0) return;
		DefaultMutableTreeNode tn = (DefaultMutableTreeNode) t.getFirstChild();
		do {
			//if it has children, dump it.  Otherwise, dump the name
			if(tn.getChildCount() > 0) DumpNode(tn, os);
			else {

				x = tn.getLevel();
				for(int i = 0; i < x; i++){
					os.writeBytes("  |");
//				   os.write(' ');os.write(' ');os.write('|');
				}
				os.writeBytes("--");
//			   os.write('-');os.write('-');

				tmp = tn.toString();
				os.writeBytes(tmp);
/*			   x = tmp.length();
				for(int i = 0; i < x; i++){
					os.write(tmp.charAt(i));
				}
				os.write('\r');os.write('\n');*/
				os.writeBytes("\r\n");
				Saved++;
			}

		} while ( (tn = (DefaultMutableTreeNode) t.getChildAfter(tn)) != null);
	}

	private int Count;
	private int Saved;

	private void DoRootExportCount(){
		//now get root
		Count = 0;
		DefaultMutableTreeNode tnRoot = (DefaultMutableTreeNode) tmModel.getRoot();
		DumpNodeCount(tnRoot);
		//now dump other root level nodes...
		DefaultMutableTreeNode tn;
		while( (tn = tnRoot.getNextSibling()) != null) {
			DumpNodeCount(tn);
		}
	}

	private void DoExportCount(DefaultMutableTreeNode tn){
		//now get root
		Count = 0;
		DumpNodeCount(tn);
	}

	private void DumpNodeCount(DefaultMutableTreeNode t) {
		Count++;
		if(t.getChildCount() == 0) return;

		DefaultMutableTreeNode tn = (DefaultMutableTreeNode) t.getFirstChild();
		do {
			//if it has children, dump it.  Otherwise, dump the name
			if(tn.getChildCount() > 0) DumpNodeCount(tn);
			else Count++;
		} while ( (tn = (DefaultMutableTreeNode) t.getChildAfter(tn)) != null);
	}
}
