//Java Information Utility
//Copyright (C) 1999 DW Software.  All Rights Reserved.
import java.awt.*;
import java.util.*;
import java.awt.event.*;
import java.io.*;

public class JInfo11 extends java.applet.Applet implements WindowListener, ActionListener{
 	private TextArea ta;

    public static void main(String args[]){
        if(args.length > 0) {
            System.out.println(getSysInfo());
            return;
        }

        Frame app = new Frame("JInfo 1.1");
//      app.setSize(408,429);
        app.setBackground(Color.lightGray);

        //resize
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        app.setSize((d.width * 3) / 4, (d.height * 3) / 4);
        Dimension b = app.getSize();
        app.setLocation((d.width - b.width) / 2, (d.height - b.height) / 2);


        JInfo11 g = new JInfo11();
 
        app.addWindowListener(g);
 
       g.init();
       g.start();
       app.add(g, BorderLayout.CENTER);
       app.setVisible(true);
 
    }
    private Button refreshBtn, quitBtn, saveBtn;
    private Toolbar toolbar;
 
 	public void init () {
        setLayout(new BorderLayout());
       	ta = new TextArea();
       	setBackground(Color.lightGray);
       	ta.setBackground(Color.white);
 
        ta.setFont(new Font("Monospaced", 0, 14));
       	add("Center", ta);
       	getInfo();
       	addToolbar();
 
        //resize
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        setSize((d.width * 3) / 4, (d.height * 3) / 4);
        Dimension b = getSize();
        setLocation((d.width - b.width) / 2, (d.height - b.height) / 2);
 
       	setVisible(true);
    	ta.setEditable(false);
 	}
 
     private static String getSysInfo() {
        //Screen size and dpi
        Toolkit tk = Toolkit.getDefaultToolkit();
        int resolution = tk.getScreenResolution();
        Dimension dim = tk.getScreenSize();
 
        StringBuffer sb = new StringBuffer();
        sb.append("Screen Resolution (in dpi): " + String.valueOf(resolution));
        sb.append(" Screen size: " + dim.width + "x" + dim.height + "\n");
        //font list
        String fonts[] = tk.getFontList();
        sb.append("Fonts Available:\n");
        for(int i = 0; i < fonts.length; i++){
       	sb.append("     \"" + fonts[i] + "\"\n");
        }
        //current time
        long time = System.currentTimeMillis();
        sb.append("It has been " + time + " milliseconds since January 1st, 1970\n");
        //properties
        try{
            sb.append("System Properties:\n");
            sb.append("     Java version: " + System.getProperty("java.version") + "\n");
            sb.append("     Java vendor: " + System.getProperty("java.vendor") + "\n");
            sb.append("     Java vendor's URL: " + System.getProperty("java.vendor.url") + "\n");
            sb.append("     Home Java folder: " + System.getProperty("java.home") + "\n");
            sb.append("     Java class version: " + System.getProperty("java.class.version") + "\n");
            sb.append("     Java class path: " + System.getProperty("java.class.path") + "\n");
            sb.append("     Operating System: " + System.getProperty("os.name") + "\n");
            sb.append("     Operating system architecture: " + System.getProperty("os.arch") + "\n");
            sb.append("     Operating system version: " + System.getProperty("os.version") + "\n");
            sb.append("     File separator: " + System.getProperty("file.separator") + "\n");
            sb.append("     Path separator: " + System.getProperty("path.separator") + "\n");
            sb.append("     User name: " + System.getProperty("user.name") + "\n");
            sb.append("     User's home directory: " + System.getProperty("user.home") + "\n");
            sb.append("     Current working directory: " + System.getProperty("user.dir") + "\n");
            sb.append("File Properties:\n");
            sb.append("     Path Separator String: " + File.pathSeparator + "\n");
            sb.append("     Path Separator char: " + File.pathSeparatorChar + "\n");
            sb.append("     Separator String: " + File.separator + "\n");
            sb.append("     Separator char: " + File.separatorChar + "\n");
        } catch (Exception e) {;}
        //memory
        sb.append("System Memory Information:\n");
        Runtime r = Runtime.getRuntime();
        r.gc();
        sb.append("     Free memory: " + r.freeMemory() + " bytes\n");
        sb.append("     Total memory: " + r.totalMemory() + " bytes\n");
        sb.append("     Memory in use: " + (r.totalMemory() - r.freeMemory()) + " bytes\n");
 
        //Now just list ALL properties...
        try{
            sb.append("Dump of all defined properties:\n");
            Properties props = System.getProperties();
            Enumeration enu = props.propertyNames();
            String name;
 
            while(enu.hasMoreElements()) {
              try {
                name = (String) enu.nextElement();
                if(name.equals("line.separator")) continue;
                sb.append("     \""+name+"\" = \""+System.getProperty(name) + "\"\n");
              } catch (Exception e) {}
            }
        } catch (Exception e){}

       String temp = System.getProperty("line.separator");
        String pmet = "";
        for(int i = 0; i < temp.length(); i++) {
            char x = temp.charAt(i);
            if(x == '\r') pmet += "\\r";//pmet += "0x000D";
            else if(x == '\n') pmet += "\\n";//pmet += "0x000A";
            else pmet += x;
        }
        sb.append("     \"line.separator\" = \""+pmet+"\"\n");
 
        //Now list Swing properties...
        try{
            sb.append("Dump of Swing properties:\n");
            Class cUIManager = Class.forName("javax.swing.UIManager");
            java.lang.reflect.Method mGetDefaults = cUIManager.getMethod("getDefaults", null);
            Hashtable props = (Hashtable)mGetDefaults.invoke(null, null);
 
            Enumeration enu = props.keys();
            String name;
 
            while(enu.hasMoreElements()) {
                Object key = enu.nextElement();
                sb.append("     \""+key+"\" = \""+props.get(key) + "\"\n");
            }
        } catch (Exception e){;}
 
        sb.append("=== End of output ===\n");
        return sb.toString();
    }

    private void getInfo(){
        ta.setText(getSysInfo());
    }

    private void addToolbar() {
        toolbar = new Toolbar();
        toolbar.setFont(new Font("Arial", Font.BOLD, 14));
        toolbar.setLayout(new FlowLayout(FlowLayout.LEFT));
        add("North", toolbar);
 
        refreshBtn = new Button("Refresh");
        refreshBtn.addActionListener(this);
        toolbar.add(refreshBtn);
 
        SecurityManager sm = System.getSecurityManager();
 
        try {
            if(sm != null) sm.checkExit(0);
            quitBtn = new Button("Quit");
            quitBtn.addActionListener(this);
            toolbar.add(quitBtn);
        } catch (Exception e) {}
 
        try {
            if(sm != null) sm.checkWrite("*.*");       
            saveBtn = new Button("Save");
            saveBtn.addActionListener(this);
            toolbar.add(saveBtn);
        } catch (Exception e) {}
    }
 
    //ActionListener
    public void actionPerformed(ActionEvent e){
    	if(e.getSource() == refreshBtn) getInfo();
       	else if(e.getSource() == quitBtn) System.exit(0);
      	else if(e.getSource() == saveBtn) OnFileSave();
    }
 
    private static final String crlf = System.getProperty("line.separator");
 
    private void OnFileSave() {
        try {
            FileDialog fd = new FileDialog(new Frame(), "Save Output...", FileDialog.SAVE);
            fd.show();
            if(fd.getFile() != null) {
                FileWriter fw = new FileWriter(fd.getDirectory()+fd.getFile());
                String output = ta.getText();
                StringTokenizer st = new StringTokenizer(output, "\r\n", false);
 
                while(st.hasMoreTokens())
                    fw.write(st.nextToken()+crlf);
 //               fw.write(output, 0, output.length());
                fw.close();
            }
        } catch (Exception e) {e.printStackTrace();}
    }
 
    //WindowListener
    public void windowActivated(WindowEvent e) {;}
    public void windowDeactivated(WindowEvent e) {;}
    public void windowIconified(WindowEvent e) {;}
    public void windowDeiconified(WindowEvent e) {;}
    public void windowOpened(WindowEvent e) {;}
    public void windowClosed(WindowEvent e) {;}
    public void windowClosing(WindowEvent e) {System.exit(0);}
}
