/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;

public class AtomicTable
extends JPanel
implements IPanelListener,
ActionListener {
    private Vector layout;
    private Hashtable elements;
    private Hashtable types;
    private Hashtable classes;
    private Hashtable states;
    private Hashtable buttons = new Hashtable();
    private PropertyPanelManager ppmgr;
    private StatusBar sb;
    private JButton btnSelected;
    private TElement teSelected;
    private JMenuItem miSaveTable = new JMenuItem("Save Table Image...", 83);
    private JMenuItem miPrintTable = new JMenuItem("Print Table Image...", 80);
    private JMenu pmContext = new JCoolMenu("Table");

    public AtomicTable(LoadStatusManager loadStatusManager, PropertyPanelManager propertyPanelManager, DatabaseManager databaseManager, ConfigManager configManager, JPeriod99 jPeriod99, StatusBar statusBar) {
        this.layout = databaseManager.getLayout();
        this.elements = databaseManager.getElements();
        this.types = databaseManager.getTypes();
        this.classes = databaseManager.getClasses();
        this.states = databaseManager.getStates();
        this.ppmgr = propertyPanelManager;
        this.sb = statusBar;
        Enumeration enumeration = this.layout.elements();
        int n = Integer.parseInt((String)enumeration.nextElement());
        int n2 = Integer.parseInt((String)enumeration.nextElement());
        this.setBackground(Color.black);
        GridLayout gridLayout = new GridLayout(n2, n, 5, 5);
        this.setLayout(gridLayout);
        Insets insets = new Insets(0, 0, 0, 0);
        int n3 = 0;
        for (int i = 2; i < this.layout.size(); ++i) {
            String string = (String)enumeration.nextElement();
            if (Character.isDigit(string.charAt(0))) {
                n3 = Integer.parseInt(string);
                if (n3 != 0) {
                    TElement tElement = (TElement)this.elements.get(new Integer(n3));
                    JButton jButton = new JButton(tElement.Symbol);
                    jButton.setMargin(insets);
                    jButton.setActionCommand(Integer.toString(tElement.AtomicNumber));
                    jButton.addActionListener(this);
                    jButton.setBackground(TElementType.getTypeColor(tElement.ElementType, this.types));
                    jButton.setToolTipText(tElement.Name + "(" + tElement.AtomicNumber + ")");
                    jButton.setBorder(new LineBorder(TClass.getClassColor(tElement.ClassType, this.classes), 2));
                    jButton.setForeground(TState.getStateColor(tElement.State, this.states));
                    this.buttons.put(new Integer(tElement.AtomicNumber), jButton);
                    this.add(jButton);
                    continue;
                }
                this.add(new JLabel());
                continue;
            }
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.reverse();
            stringBuffer.setLength(stringBuffer.length() - 1);
            stringBuffer.reverse();
            JLabel jLabel = new JLabel(stringBuffer.toString(), 0);
            jLabel.setForeground(Color.white);
            this.add(jLabel);
        }
        this.ppmgr.addProperty(this);
        if (configManager.canWriteFiles()) {
            this.miSaveTable.addActionListener(this);
            this.miSaveTable.setActionCommand("FileSaveTable");
            this.pmContext.add(this.miSaveTable);
        }
        if (configManager.canPrint()) {
            this.miPrintTable.addActionListener(this);
            this.miPrintTable.setActionCommand("FilePrintTable");
            this.pmContext.add(this.miPrintTable);
        }
        this.pmContext.setMnemonic('T');
        JMenuBar jMenuBar = jPeriod99.getJMenuBar();
        jMenuBar.add(this.pmContext);
        jMenuBar.invalidate();
        jMenuBar.validate();
    }

    public void onDeactivate(PanelEvent panelEvent) {
    }

    public void onActivate(PanelEvent panelEvent) {
    }

    public void setAtom(PanelEvent panelEvent) {
        TElement tElement = panelEvent.getElement();
        JButton jButton = (JButton)this.buttons.get(new Integer(tElement.AtomicNumber));
        if (jButton == null) {
            return;
        }
        if (this.btnSelected != null) {
            this.btnSelected.setBackground(TElementType.getTypeColor(this.teSelected.ElementType, this.types));
            this.btnSelected.repaint();
        }
        this.btnSelected = jButton;
        this.teSelected = tElement;
        jButton.setBackground(jButton.getBackground().darker());
        jButton.repaint();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("FileSaveTable")) {
            this.OnFileSaveTable();
        } else if (!string.equals("FilePrintTable")) {
            this.ppmgr.setAtom(Integer.parseInt(string));
        }
    }

    public void setStyle(PanelEvent panelEvent) {
    }

    private void OnFileSaveTable() {
        try {
            SimpleFileFilter simpleFileFilter = new SimpleFileFilter("bmp", "Windows Bitmap");
            DoFileDialog doFileDialog = new DoFileDialog((Component)this, "Save Graph Image...", 1, simpleFileFilter);
            String string = doFileDialog.getPath();
            if (string.equals("")) {
                return;
            }
            Dimension dimension = this.getSize();
            Image image = this.createImage(dimension.width, dimension.height);
            if (image == null) {
                System.err.println("ibuffer = null");
                return;
            }
            Graphics graphics = image.getGraphics();
            if (graphics == null) {
                System.err.println("gBuffer = null");
                return;
            }
            graphics.setClip(0, 0, dimension.width, dimension.height);
            this.paint(graphics);
            this.sb.setText("Saving " + string + "...");
            BitmapCodec bitmapCodec = new BitmapCodec(this);
            bitmapCodec.saveBitmap(string, image);
            this.sb.setText("Saved " + string + ".");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void updateUI() {
        super.updateUI();
        if (this.pmContext != null) {
            this.pmContext.updateUI();
        }
    }
}

