/*
 * Decompiled with CFR 0.152.
 */
class FloatingNumber {
    boolean isExceptional;
    boolean isNegative;
    int decExponent;
    char[] digits;
    int nDigits;
    int bigIntExp;
    int bigIntNBits;
    boolean mustSetRoundDir = false;
    int roundDir;
    static final long signMask = Long.MIN_VALUE;
    static final long expMask = 0x7FF0000000000000L;
    static final long fractMask = 0xFFFFFFFFFFFFFL;
    static final int expShift = 52;
    static final int expBias = 1023;
    static final long fractHOB = 0x10000000000000L;
    static final long expOne = 0x3FF0000000000000L;
    static final int maxSmallBinExp = 62;
    static final int minSmallBinExp = -21;
    static final int maxDecimalDigits = 15;
    static final int maxDecimalExponent = 308;
    static final int minDecimalExponent = -324;
    static final int bigDecimalExponent = 324;
    static final long highbyte = -72057594037927936L;
    static final long highbit = Long.MIN_VALUE;
    static final long lowbytes = 0xFFFFFFFFFFFFFFL;
    static final int singleSignMask = Integer.MIN_VALUE;
    static final int singleExpMask = 2139095040;
    static final int singleFractMask = 0x7FFFFF;
    static final int singleExpShift = 23;
    static final int singleFractHOB = 0x800000;
    static final int singleExpBias = 127;
    static final int singleMaxDecimalDigits = 7;
    static final int singleMaxDecimalExponent = 38;
    static final int singleMinDecimalExponent = -45;
    static final int intDecimalDigits = 9;
    private static final double[] small10pow = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11, 1.0E12, 1.0E13, 1.0E14, 1.0E15, 1.0E16, 1.0E17, 1.0E18, 1.0E19, 1.0E20, 1.0E21, 1.0E22};
    private static final float[] singleSmall10pow = new float[]{1.0f, 10.0f, 100.0f, 1000.0f, 10000.0f, 100000.0f, 1000000.0f, 1.0E7f, 1.0E8f, 1.0E9f, 1.0E10f};
    private static final double[] big10pow = new double[]{1.0E16, 1.0E32, 1.0E64, 1.0E128, 1.0E256};
    private static final double[] tiny10pow = new double[]{1.0E-16, 1.0E-32, 1.0E-64, 1.0E-128, 1.0E-256};
    private static final int maxSmallTen = small10pow.length - 1;
    private static final int singleMaxSmallTen = singleSmall10pow.length - 1;
    private static final int[] small5pow = new int[]{1, 5, 25, 125, 625, 3125, 15625, 78125, 390625, 1953125, 9765625, 48828125, 244140625, 1220703125};
    private static final long[] long5pow = new long[]{1L, 5L, 25L, 125L, 625L, 3125L, 15625L, 78125L, 390625L, 1953125L, 9765625L, 48828125L, 244140625L, 1220703125L, 6103515625L, 30517578125L, 152587890625L, 762939453125L, 3814697265625L, 19073486328125L, 95367431640625L, 476837158203125L, 2384185791015625L, 11920928955078125L, 59604644775390625L, 298023223876953125L, 1490116119384765625L};
    private static final int[] n5bits = new int[]{0, 3, 5, 7, 10, 12, 14, 17, 19, 21, 24, 26, 28, 31, 33, 35, 38, 40, 42, 45, 47, 49, 52, 54, 56, 59, 61};
    private static final char[] infinity = new char[]{'I', 'n', 'f', 'i', 'n', 'i', 't', 'y'};
    private static final char[] notANumber = new char[]{'N', 'a', 'N'};
    private static final char[] zero = new char[]{'0', '0', '0', '0', '0', '0', '0', '0'};

    private FloatingNumber(boolean bl, int n, char[] cArray, int n2, boolean bl2) {
        this.isNegative = bl;
        this.isExceptional = bl2;
        this.decExponent = n;
        this.digits = cArray;
        this.nDigits = n2;
    }

    public static FloatingNumber readJavaFormatString(String string) throws NumberFormatException {
        block30: {
            boolean bl = false;
            boolean bl2 = false;
            try {
                string = string.trim();
                int n = string.length();
                if (n == 0) {
                    throw new NumberFormatException("empty String");
                }
                int n2 = 0;
                char c = string.charAt(n2);
                switch (c) {
                    case '-': {
                        bl = true;
                    }
                    case '+': {
                        ++n2;
                        bl2 = true;
                    }
                }
                char[] cArray = new char[n];
                int n3 = 0;
                boolean bl3 = false;
                int n4 = 0;
                int n5 = 0;
                int n6 = 0;
                block18: while (n2 < n) {
                    c = string.charAt(n2);
                    switch (c) {
                        case '0': {
                            if (n3 > 0) {
                                ++n6;
                                break;
                            }
                            ++n5;
                            break;
                        }
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            while (n6 > 0) {
                                cArray[n3++] = 48;
                                --n6;
                            }
                            cArray[n3++] = c;
                            break;
                        }
                        case '.': {
                            if (bl3) {
                                throw new NumberFormatException("multiple points");
                            }
                            n4 = n2;
                            if (bl2) {
                                --n4;
                            }
                            bl3 = true;
                            break;
                        }
                        default: {
                            break block18;
                        }
                    }
                    ++n2;
                }
                if (n3 == 0) {
                    cArray = zero;
                    n3 = 1;
                    if (n5 == 0) break block30;
                }
                int n7 = bl3 ? n4 - n5 : n3 + n6;
                if (n2 < n && (c = string.charAt(n2)) == 'e' || c == 'E') {
                    int n8 = 1;
                    int n9 = 0;
                    int n10 = 0xCCCCCCC;
                    boolean bl4 = false;
                    switch (string.charAt(++n2)) {
                        case '-': {
                            n8 = -1;
                        }
                        case '+': {
                            ++n2;
                        }
                    }
                    int n11 = n2;
                    block20: while (n2 < n) {
                        if (n9 >= n10) {
                            bl4 = true;
                        }
                        c = string.charAt(n2++);
                        switch (c) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                n9 = n9 * 10 + (c - 48);
                                continue block20;
                            }
                        }
                        --n2;
                        break;
                    }
                    int n12 = 324 + n3 + n6;
                    n7 = bl4 || n9 > n12 ? n8 * n12 : (n7 += n8 * n9);
                    if (n2 == n11) break block30;
                }
                if (n2 >= n || n2 == n - 1 && (string.charAt(n2) == 'f' || string.charAt(n2) == 'F' || string.charAt(n2) == 'd' || string.charAt(n2) == 'D')) {
                    return new FloatingNumber(bl, n7, cArray, n3, false);
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        throw new NumberFormatException(string);
    }

    public float floatValue() {
        int n;
        int n2 = Math.min(this.nDigits, 8);
        int n3 = this.digits[0] - 48;
        for (n = 1; n < n2; ++n) {
            n3 = n3 * 10 + this.digits[n] - 48;
        }
        float f = n3;
        n = this.decExponent - n2;
        if (this.nDigits <= 7) {
            if (n == 0) {
                return this.isNegative ? -f : f;
            }
            if (n >= 0) {
                if (n <= singleMaxSmallTen) {
                    return this.isNegative ? -f : (f *= singleSmall10pow[n]);
                }
                int n4 = 7 - n2;
                if (n <= singleMaxSmallTen + n4) {
                    f *= singleSmall10pow[n4];
                    return this.isNegative ? -f : (f *= singleSmall10pow[n - n4]);
                }
            } else if (n >= -singleMaxSmallTen) {
                return this.isNegative ? -f : (f /= singleSmall10pow[-n]);
            }
        } else if (this.decExponent >= this.nDigits && this.nDigits + this.decExponent <= 15) {
            long l = n3;
            for (int i = n2; i < this.nDigits; ++i) {
                l = l * 10L + (long)(this.digits[i] - 48);
            }
            double d = l;
            n = this.decExponent - this.nDigits;
            f = (float)(d *= small10pow[n]);
            return this.isNegative ? -f : f;
        }
        if (this.decExponent > 39) {
            return this.isNegative ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY;
        }
        if (this.decExponent < -46) {
            return this.isNegative ? -0.0f : 0.0f;
        }
        return Float.NaN;
    }
}

