import java.applet.*;
import java.net.*;
import java.awt.*;

class ConfigManager {
   private boolean app;
   private String codeBase;
   private boolean writableFS = false;
   private boolean printable = false;
   private boolean exitVM = false;
   private boolean clipboard = false;
   private Applet applet;

   public ConfigManager(
       boolean ia,
       String cb,
       Applet a
   ) {
       app = ia;
       codeBase = cb;
       applet = a;

       try {
	        SecurityManager security = System.getSecurityManager();
	        if (security != null) security.checkWrite("*.*");
           writableFS = true;
       } catch(SecurityException e) {;}

/*       try {
	        SecurityManager security = System.getSecurityManager();
	        if (security != null) security.checkPrintJobAccess();
           printable = true;
       } catch(SecurityException e) {;}*/

       try {
	        SecurityManager security = System.getSecurityManager();
	        if (security != null) security.checkExit(0);
           exitVM = true;
       } catch(SecurityException e) {;}

       try {
	        SecurityManager security = System.getSecurityManager();
	        if (security != null) security.checkSystemClipboardAccess();
           clipboard = true;
       } catch(SecurityException e) {;}

   }

   public boolean isApp() {return app;}
   public String getCodeBase() {return codeBase;}
   public boolean canWriteFiles() {return writableFS;}
   public boolean canPrint() {return printable;}
   public boolean canExitVM() {return exitVM;}
   public boolean canGetClipboard() {return clipboard;}
   public final String getCrlf() {return System.getProperty("line.separator");}

   public Image getImage(String fname) {
       try {
           if(app) return Toolkit.getDefaultToolkit().getImage(fname);
           else return applet.getImage(new URL(fname));
       } catch (Exception e) {return null;}
   }
}