import javax.swing.*;
import java.awt.*;
import java.awt.datatransfer.*;
import java.awt.event.*;

public class TextPanel extends JPanel implements IPanelListener, ActionListener {
   private JLabel lCaption;
   private JTextArea lContent;
   private String sCaption;
   private PropertyPanelManager ppmgr;
   private PropertyPanelScript script;
   private int index = -1;

   private JMenuItem miCopyToClipboard = new JMenuItem("Copy to Clipboard...", 'C');
   private JMenuItem miPrintGraph = new JMenuItem("Print Text...", 'P');
   private JMenu pmContext = new JCoolMenu("Panel");

   public String toString() {return sCaption;}

   public TextPanel(PropertyPanelScript s, int idx, String sc, PropertyPanelManager pp, ConfigManager cfgmgr) {
       index = idx;
       sCaption = sc;
       ppmgr = pp;
       script = s;

       lCaption = new JLabel(sCaption);
       setLayout(new BorderLayout());
       add("North", lCaption);

       lContent = new JTextArea("????");
       lContent.setLineWrap(true);
       lContent.setWrapStyleWord(true);

       Font f = lContent.getFont();
       lContent.setFont(new Font("Arial", f.getStyle(), 36));

       lContent.setBackground(getBackground());
       lContent.setBorder(null);
       lContent.setEditable(false);
       JScrollPane sp = new JScrollPane(lContent);
       add("Center", sp);

       if(cfgmgr.canGetClipboard()) {
           miCopyToClipboard.addActionListener(this);
           miCopyToClipboard.setActionCommand("CopyToClipboard");
           pmContext.add(miCopyToClipboard);
       }

       if(cfgmgr.canPrint()) {
           miPrintGraph.addActionListener(this);
           miPrintGraph.setActionCommand("FilePrintText");
           pmContext.add(miPrintGraph);
       }
       pmContext.setMnemonic('P');
   }

   public void setAtom(PanelEvent pe) {
       lContent.setText(script.getTextPanelData(index, pe.getElement()));
   }

   public void onActivate(PanelEvent pe) {
       ppmgr.addMenu(pmContext);
   }

   public void onDeactivate(PanelEvent pe) {
       ppmgr.removeMenu(pmContext);
   }

   public void actionPerformed(ActionEvent e){
       String s = e.getActionCommand();
       if (s.equals("FilePrintText")) {
       	OnFilePrintText();
       } else if(s.equals("CopyToClipboard")) {
           OnCopyToClipboard();
       }

   }

   private void OnFilePrintText() {
   }

   private void OnCopyToClipboard() {
       StringSelection ss = new StringSelection(lContent.getText());
       Clipboard c = Toolkit.getDefaultToolkit().getSystemClipboard();
       c.setContents(ss, ss);
   }

   public void setStyle(PanelEvent pe) {}

   public void updateUI() {
       super.updateUI();
       if(pmContext != null) pmContext.updateUI();
   }
}
