import java.awt.*;
import java.lang.reflect.*;
import java.applet.*;
import java.awt.event.*;

public class Wizard extends Panel implements ActionListener {
   private final static String sNext = "Next >";
   private final static String sBack = "< Back";
   private final static String sCancel = "Exit";

   private MyButton bNext = new MyButton(sNext);
   private MyButton bBack = new MyButton(sBack);
   private MyButton bCancel = new MyButton(sCancel);
   private NavPanel pNavBar = new NavPanel();

   public Button getBack() {return bBack;}
   public Button getNext() {return bNext;}
   public Button getCancel() {return bCancel;}

   public boolean isApp = false;
   private IScript is;

   private void adjustButton(Button b) {
       Font f = b.getFont();
       Font f1 = new Font(f.getFamily(), 0, f.getSize());
       b.setFont(f1);
   }

   public Wizard(boolean isapp, IScript IS) {
       isApp = isapp;
       is = IS;
       add("Center", new Label("You need Java 1.1 for this program!"));
       try {
           setEnabled(true);
       } catch (NoSuchMethodError e) {
           System.err.println("You must have Java 1.1 to install this program!");
           return;
       } catch (VerifyError e) {
           System.err.println("You must have Java 1.1 to install this program!");
           return;
       }

       removeAll();

       setLayout(new BorderLayout());
       setBackground(Color.lightGray);
       pNavBar.setLayout(new FlowLayout(FlowLayout.RIGHT));

       pNavBar.add(bBack);
       bBack.setEnabled(false);
       pNavBar.add(bNext);

       add("South", pNavBar);
       bBack.addActionListener(this);bNext.addActionListener(this);bCancel.addActionListener(this);

       if(isApp) pNavBar.add(bCancel);
       try {
           pNavBar.invalidate();
           invalidate();
           validate();
//           doLayout();
//           pNavBar.doLayout();
       } catch (NoSuchMethodError e) {e.printStackTrace();
           return;
       }
   }

   private Component lastAdded = null;

   public void setContent(Component p) {
       if(lastAdded != null) remove(lastAdded);
       add("Center", p);
       p.invalidate();
       validate();
       lastAdded = p;
   }

//   public void doLayout() {System.out.println("doLayout");super.doLayout();}

   public void actionPerformed(ActionEvent e) {
       Object o = e.getSource();
       if(o == bNext) {
           is.onNext();
       } else if (o == bBack) {
           is.onBack();
       } else if (o == bCancel) {
           is.onCancel();
       }
   }
}

class NavPanel extends Panel {
   public void paint(Graphics g) {
       Dimension d = getSize();
       int w = (int)Math.round(d.width * 0.9);
       g.setColor(Color.lightGray);
       g.draw3DRect((d.width-w)/2, 0, w, 1, false);
   }
}
