import java.io.*;
import java.util.*;

class RequestHelper {
    public static final int SF_NAME = 0;
    public static final int SF_SIZE = 1;
    public static final int SF_DATE = 2;
    public static final int SF_ATTR = 3;
    public static final int SF_MIME = 4;

    /*  URL HELPERS
        ===========

        These functions convert special URL escape sequences like %20 back into
        proper ASCII characters, and vice versa.

        We usually run decodeURL() on incoming URLs, and encodeURL() to encode
        outgoing URLs.
    */

    public static String decodeURL(String ex) {
        try {
            StringBuffer result = new StringBuffer();
            for(int i=0;i<ex.length();i++) {
                char x = ex.charAt(i);
                if(x == '%') {
                    try {
                        char esc[] = {ex.charAt(i+1), ex.charAt(i+2)};
                        String escape = new String(esc);
                        i += 2;
                        result.append((char)Integer.parseInt(escape, 16));
                    } catch (Exception e) {
                        result.append(x);
                    }
                } else {
                    result.append(x);
                }
            }
            return result.toString();
        } catch (NumberFormatException nfe) {return ex;}
    }

    public static String encodeURL(String ex) {
        StringBuffer sb = new StringBuffer();
        StringTokenizer st = new StringTokenizer(ex, " ", false);
        String f;

        while(st.hasMoreTokens()) {
            f = st.nextToken();
            sb.append(f);
            if(st.hasMoreTokens()) sb.append("%20");
        }
        return sb.toString();
    }


    /*  SORTING FILES
        =============

        We use MergeSort algorithm, (cough) stolen out of the Java2 sources.
    */

    public static void sortSuperFiles(SuperFile[] a, int how, boolean csfs, MimeDatabase md) {
        SuperFile aux[] = (SuperFile[])a.clone();
        mergeSort(aux, a, 0, a.length, how, csfs, md);
    }

    private static void mergeSort(SuperFile src[], SuperFile dest[], int low, int high, int how, boolean csfs, MimeDatabase md) {
        int length = high - low;

        // Insertion sort on smallest arrays
        if (length < 7) {
            for (int i=low; i<high; i++)
                for (int j=i; j>low && compareSuperFiles(dest[j-1], dest[j], how, csfs, md) > 0; j--)
                    swap(dest, j, j-1);
            return;
        }

        // Recursively sort halves of dest into src
        int mid = (low + high)/2;
        mergeSort(dest, src, low, mid, how, csfs, md);
        mergeSort(dest, src, mid, high, how, csfs, md);

        // If list is already sorted, just copy from src to dest.  This is an
        // optimization that results in faster sorts for nearly ordered lists.
        if( compareSuperFiles(src[mid-1], src[mid], how, csfs, md) <= 0) {
            System.arraycopy(src, low, dest, low, length);
            return;
        }

        // Merge sorted halves (now in src) into dest
        for(int i = low, p = low, q = mid; i < high; i++) {
            if (q>=high || p<mid && compareSuperFiles(src[p], src[q], how, csfs, md) <= 0 )
                dest[i] = src[p++];
            else
                dest[i] = src[q++];
        }
    }

    private static int compareSuperFiles(SuperFile one, SuperFile two, int how, boolean csfs, MimeDatabase md) {
        switch(how) {
            case SF_NAME:
                return ( csfs ? compareStringsCS(one.getName(), two.getName()) : compareStringsCI(one.getName(), two.getName()) );
            case SF_SIZE:
                if(one.length() > two.length()) return 1;
                else if(one.length() < two.length()) return -1;
                else return 0;
            case SF_DATE:
                if(one.lastModified() > two.lastModified()) return 1;
                else if(one.lastModified() < two.lastModified()) return -1;
                else return 0;
            case SF_ATTR:
                return compareStringsCI(one.getAttrs(), two.getAttrs());
            case SF_MIME:
                try {
                    return compareStringsCI(md.getMimeType(one), md.getMimeType(two));
                } catch (IOException e) {
                    return 0;
                }
            default: return 0;
        }
    }

    private static int compareStringsCI(String one, String two) {
        return compareStringsCS(one.toLowerCase(), two.toLowerCase());
    }

    private static int compareStringsCS(String one, String two) {
        int len1 = one.length();
        int len2 = two.length();
        int n = Math.min(len1, len2);
        char v1[] = one.toCharArray();
        char v2[] = two.toCharArray();
        int i = 0;
        int j = 0;
   
        while (n-- != 0) {
            char c1 = v1[i++];
            char c2 = v2[j++];
            if (c1 != c2) {
                return c1 - c2;
            }
        }
        return len1 - len2;
    }
   
    private static void swap(SuperFile x[], int a, int b) {
        SuperFile t = x[a];
        x[a] = x[b];
        x[b] = t;
    }
   
    public static String padNumber(long x) {
        String result = "";
        if( (x<10) && (x>=0) ) { result = "0";}
        result += x;
        return result;
    }

    public static String getPadding(String x, int len) {
        if(x.length() >= len) return "";
        StringBuffer sb = new StringBuffer();
        for(int i = x.length(); i < len; i++) {
            sb.append(" ");
        }
        return sb.toString();
    }

    public static String padString(String x, int len) {
        if(x.length() >= len) return x;
        return x + getPadding(x, len);
    }

    public static int getBiggestStringLength(SuperFile[] array, int which, MimeDatabase md) {
        int result = 0;
        switch(which) {
            case SF_NAME:
                for(int i=0;i<array.length; i++) {
                    if( array[i].getName().length() > result) result = array[i].getName().length();
                }
                break;
            case SF_SIZE:
                for(int i=0;i<array.length; i++) {
                    if( array[i].getFileSize().length() > result) result = array[i].getFileSize().length();
                }
                break;
            case SF_DATE:
                for(int i=0;i<array.length; i++) {
                    if( array[i].getLastModified().length() > result) result = array[i].getLastModified().length();
                }
                break;
            case SF_ATTR:
                for(int i=0;i<array.length; i++) {
                    if( array[i].getAttrs().length() > result) result = array[i].getAttrs().length();
                }
                break;
            case SF_MIME:
                for(int i=0;i<array.length; i++) {
                    try {
                        if( md.getMimeType(array[i]).length() > result) result = md.getMimeType(array[i]).length();
                    } catch (IOException e) {}
                }
                break;
            default: throw new IllegalArgumentException("RequestHelper.getBiggestStringLength: which must be between SF_NAME and SF_MIME; it is "+which);
        }
        return result;
    }

    public static void pipeData(
        InputStream in,
        OutputStream out,
        long length,
        int bufsize
    ) throws IOException {
        byte data[] = new byte[bufsize];
        long cnt =0;
        int incount;

        incount = in.read(data);
        while ((cnt += incount) <= length) {
            out.write(data, 0, incount);
        }
    }

    public static void pipeData(
        InputStream in,
        OutputStream out,
        int bufsize
    ) throws IOException {
        byte data[] = new byte[bufsize];
        int cnt =0;

        while ((cnt = in.read(data)) != -1) {
            out.write(data, 0, cnt);
        }
    }
}