/* Server.java...grabs incoming requests and sends them to the handler.
   Copyright (C) 1999 Darrick Wong
*/
import java.net.*;
import java.io.*;

public class Server extends Thread {
    private ServerConf m_scServerConfiguration;
    private ServerSocket m_ssServerSocket;
    private ThreadPool m_tpPool;

    public ServerConf getServerConfiguration() {return m_scServerConfiguration;}

    private Server() {} //block empty constructor...

    public Server(ServerConf sc, ThreadPool tp) {
        super();
        m_scServerConfiguration = sc;
        m_tpPool = tp;
//        setDaemon(true);  //can't do this otherwise httpd exits.
        start();
    }

    public void run() {
        if(m_scServerConfiguration.getDebugLevel() > 0) {
            m_scServerConfiguration.print(getName(), "Initializing httpd port "+
                m_scServerConfiguration.getPort()+":"
            );
        }

        //First, see if we have any virtual hosts.  If not, then die.
        if(m_scServerConfiguration.getVirtualHosts().size() == 0) {
            m_scServerConfiguration.println(getName(), "Server on port "+
                m_scServerConfiguration.getPort()+" does not have any virtual "+
                "hosts configured.  Please tell the administrator to add one to "+
                "this server."
            );

        }

        //Establish the server socket connection.
        try {
            m_ssServerSocket = new ServerSocket(m_scServerConfiguration.getPort(), m_scServerConfiguration.getIncomingQueueSize());
        } catch (IOException e) {
            e.printStackTrace(m_scServerConfiguration.getErrorStream());
            return;  //die!
        }

        if(m_scServerConfiguration.getDebugLevel() > 0) {
            m_scServerConfiguration.println(" httpd");
        }

/*        if(m_scServerConfiguration.getDebugLevel() > 4) {
            m_scServerConfiguration.println(getName(), "Server on port "+
                m_scServerConfiguration.getPort()+" has been bootstrapped and is ready to go!");
        }
*/
        //Loop around making connections.
        Socket client = null;
        RequestHandler rh = null;
        while(true) {
            try {
                if(interrupted()) return;
                client = m_ssServerSocket.accept();
                if(m_scServerConfiguration.getDebugLevel() > 4) {
                    m_scServerConfiguration.println(getName(), "Accepting socket from "+client);
                }
                while( (rh = m_tpPool.getRequestHandler()) == null) yield();
                m_scServerConfiguration.incTotalRequests();
                
                rh.sendRequest(m_scServerConfiguration, client);
            } catch (IOException e) {
                if(m_scServerConfiguration.getDebugLevel() > 1) {
                    e.printStackTrace(m_scServerConfiguration.getErrorStream());
                }
            }
        }
    }
    
    public void dumpConfig(StringBuffer s) {
		//m_ssServerSocket
		m_scServerConfiguration.dumpConfig(s);		
    }
}