/* httpd.java -- Invoke web server...
   Copyright (C) 1999 Darrick Wong
*/

import java.io.*;
import java.util.*;

public class httpd {
    public static void main(String args[]) throws Exception {
        if(args[0].charAt(1) == '?') {
            displaySyntax();
        } else {
            httpd x = new httpd(args);
        }
    }

    public static void displaySyntax() {
        System.out.print(
            httpdconf.sProdName+".\r\n"+
            "\r\n"+
            "Starts an HTTP server.\r\n"+
            "\r\n"+
            "httpd [-C configfile]\r\n"+
            "\r\n"+
            "   -C  Tells httpd to read configfile for configuration data.\r\n"+
            "       Default: config.txt\r\n"
        );
    }

    public httpd(String args[]) throws Exception {
        //This is temporary:
        //To establish a server, we need a serverconf and a threadpool.
        //eventually we'll make it read this stuff from a file, but for now
        //we just make it in code (as a TEST)

        String sConfigFile = "config.txt";

        if( (args[0].toLowerCase().charAt(1) == 'c') && (args.length > 1) ) {
            sConfigFile = args[1];
        }

        System.out.println(httpdconf.sProdName+" starting...\r\n");

        //make a reader for the config file...eventually we'll make this changeable.
        FileReader frConfig = null;

        try {
            String input;
            SuperInt i = new SuperInt(0);

            //hold virtual hosts and servers.
            Hashtable vVirtualHosts = new Hashtable();
            Vector vServers = new Vector();

            //This MUST be initialized
            httpdconf hc = null;

            for(int idx=0;idx<3;idx++) {
                try {
                    frConfig = new FileReader(sConfigFile);
                    BufferedReader brConfig = new BufferedReader(frConfig);

                    while( (input = brConfig.readLine()) != null) {
                        input = input.trim().toLowerCase();
                        i.increment();
                        //skip comments
                        if(input.startsWith("//") || input.startsWith(";") || input.startsWith("#") || input.equals("")) continue;

                        //if we're encountering an object, read it.
                        if(input.startsWith("httpdconf")) {
                            if(idx == 0) {
                                hc = httpdconf.generateConfigFromStrings(brConfig, i);
                            }
                        } else if (input.startsWith("vhostconf")) {
                            if(idx == 1) {
                                if(hc == null) throw new Exception("Parse error, line "+i+": no \"httpdconf\" exists in the config file!");
                                VHostConf vhc = VHostConf.generateConfigFromStrings(brConfig, i, hc);
                                vVirtualHosts.put(vhc.getHostName().toLowerCase(), vhc);
                            }
                        } else if (input.startsWith("serverconf")) {
                            if(idx == 2) {
                                if(hc == null) throw new Exception("Parse error, line "+i+": no \"httpdconf\" exists in the config file!");
                                ServerConf sc = ServerConf.generateConfigFromStrings(brConfig, i, vVirtualHosts, hc);
                                vServers.addElement(sc);
                            }
                        }
                    } //end of while

                    //close and reopen file
                    frConfig.close();
                } catch (FileNotFoundException e) {
                    System.err.println("I cannot find the configuration file \""+sConfigFile+"\".");
                    return;
                } catch (Exception e) {
                    e.printStackTrace();
                }
            } //end of for loop

            ThreadPool tp = new ThreadPool(hc);
            hc.setThreadPool(tp);
            ServerConf sc;

            Enumeration e = vServers.elements();
            while(e.hasMoreElements()) {
                sc = (ServerConf)e.nextElement();
                hc.addServer(new Server(sc, tp));
            }
            System.out.println("Finished configuring...servers should be running.");
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if(frConfig != null)
                frConfig.close();
        }
    }
}
/*  READING CONFIGURATION FILES
    ===========================

    It is the job of main() to read the configuration data for the HTTP server.
    Essentially, we just parse through the file, looking for objects to create.

    Object format roughly resembles this:

    objecttype {
        name=something
        field=value
        another_field=another_value
        ...
    }

    Pseudocode:
    -----------

    main():
      Open file
      While string=readline, do
        trim string
        if string starts with '#', ';', or '//', skip to the next line.
        read the first word in string
        if there isn't a '{', then print error message and die.
        parse the object according to type (if first word is "httpdconf", invoke "httpdconf_parseconf()")
      done
      close file

    Parser for various object types:
      while string=readline, do
        trim string
        if string is "}", return
        read everything up to the '=', call it the key
        trim key
        read everything after the '=' up to the ';', call it the value
        if no ';', throw exception.
        trim value
        set key/value pair
      done
*/
